/*
 * Decompiled with CFR 0.152.
 */
package com.stattrack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.stattrack.StatTrackConfig;
import java.io.IOException;
import java.util.EnumMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stat Track", description="Tracks stats to compare with your friends", tags={"experience", "levels", "stats", "activity", "tracker", "group", "ironman"})
public class StatTrackPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StatTrackPlugin.class);
    @Inject
    private ConfigManager configManager;
    @Inject
    private StatTrackConfig config;
    @Inject
    private Client client;
    private final EnumMap<Skill, Integer> previousStatXp = new EnumMap(Skill.class);
    @Inject
    private OkHttpClient httpClient;
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    @Provides
    StatTrackConfig getConfig(ConfigManager configManager) {
        return (StatTrackConfig)configManager.getConfig(StatTrackConfig.class);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        log.debug("stat changed %s", (Object)statChanged);
        log.debug("current username %s", (Object)this.client.getLocalPlayer().getName());
        if (statChanged.getXp() == 0 || this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Integer previous = this.previousStatXp.put(statChanged.getSkill(), statChanged.getXp());
        if (previous == null || previous.intValue() == statChanged.getXp()) {
            return;
        }
        this.previousStatXp.put(statChanged.getSkill(), statChanged.getXp());
        if (this.config.logXp()) {
            long xp;
            Skill skill = statChanged.getSkill();
            long l = xp = skill == Skill.OVERALL ? this.client.getOverallExperience() : (long)this.client.getSkillExperience(skill);
            if (xp != 0L) {
                log.debug("about to write a test doc to MongoDB");
                this.logXp(statChanged.getSkill(), statChanged.getLevel(), statChanged.getXp(), this.client.getLocalPlayer().getName());
            }
        }
    }

    public final void logXp(Skill skill, int level, int xp, final String playerUsername) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("skill", skill.getName());
        jsonObject.addProperty("level", (Number)level);
        jsonObject.addProperty("xp", (Number)xp);
        jsonObject.addProperty("username", playerUsername);
        Gson gson = new Gson();
        String stringifiedJson = gson.toJson((JsonElement)jsonObject);
        log.debug(stringifiedJson);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)stringifiedJson);
        String url = "https://osrs-group-ironman-stats.vercel.app/api/logXp";
        String localUrl = "http://localhost:3000/api/logXp";
        Request request = new Request.Builder().url(url).post(body).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error submitting xp", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
                log.debug("Submitted xp for {}", (Object)playerUsername);
            }
        });
    }
}

