/*
 * Decompiled with CFR 0.152.
 */
package com.runewatch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.runewatch.Case;
import com.runewatch.CaseManager;
import com.runewatch.RuneWatchConfig;
import com.runewatch.RuneWatchInputListener;
import com.runewatch.RuneWatchOverlay;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import joptsimple.internal.Strings;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="RuneWatch")
public class RuneWatchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RuneWatchPlugin.class);
    private static final String INVESTIGATE = "Investigate";
    private static final String FOLDER_NAME = "Trades";
    private static final String NBSP = Character.toString('\u00a0');
    private static final String ACCEPTED_TRADE_MSG = "Accepted trade.";
    private static final String DECLINED_TRADE_MSG = "Other player declined trade.";
    private static final String DECLINE_MSG = "Decline";
    private static final Pattern TRADING_WITH_PATTERN = Pattern.compile("Trading [W|w]ith:(<br>|\\s)(.*)");
    private static final int PLAYER_TRADE_OFFER_GROUP_ID = 335;
    private static final int PLAYER_TRADE_OFFER_TRADING_WITH = 31;
    private static final int PLAYER_TRADE_OFFER_TRADE_MODIFIED_ME = 26;
    private static final int PLAYER_TRADE_OFFER_TRADE_MODIFIED_THEM = 29;
    private static final int PLAYER_TRADE_CONFIRMATION_GROUP_ID = 334;
    private static final int PLAYER_TRADE_CONFIRMATION_TRADING_WITH = 30;
    private static final int PLAYER_TRADE_CONFIRMATION_TRADE_MODIFIED_THEM = 31;
    private static final int COX_PARTY_LIST_GROUP_ID = 499;
    private static final int TOB_PARTY_LIST_GROUP_ID = 364;
    private static final int COX_PARTY_DETAILS_GROUP_ID = 507;
    private static final int TOB_PARTY_DETAILS_GROUP_ID = 50;
    private static final int SCRIPT_ID_TOB_HUD_DRAW = 2297;
    private static final int SCRIPT_ID_RAIDS_SIDEPANEL_ENTRY_SETUP = 1550;
    private static final List<Integer> TRADE_SCREEN_GROUP_IDS = Arrays.asList(335, 334);
    private static final List<Integer> MENU_WIDGET_IDS = ImmutableList.of((Object)429, (Object)432, (Object)0xA20022, (Object)7, (Object)163, (Object)500, (Object)507, (Object)50, (Object)45940742, (Object)46006278);
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Delete", (Object)"Kick", (Object)"Reject");
    @Inject
    private Client client;
    @Inject
    private RuneWatchConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private RuneWatchOverlay screenshotOverlay;
    private BufferedImage reportButton;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    CaseManager caseManager;
    @Inject
    ClientThread clientThread;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    @Inject
    RuneWatchInputListener hotkeyListener;
    @Inject
    KeyManager keyManager;
    private boolean hotKeyPressed;
    private Image tradeImage;
    private String trader;
    private static Map<String, Instant> lastNotified = new ConcurrentHashMap<String, Instant>();

    @Provides
    RuneWatchConfig provideConfig(ConfigManager configManager) {
        return (RuneWatchConfig)configManager.getConfig(RuneWatchConfig.class);
    }

    protected void startUp() {
        if (this.config.playerOption() && this.client != null) {
            this.menuManager.addPlayerMenuItem(INVESTIGATE);
        }
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.spriteManager.getSpriteAsync(3057, 0, s -> {
            this.reportButton = s;
        });
        this.overlayManager.add((Overlay)this.screenshotOverlay);
        this.caseManager.refresh(this::colorAll);
    }

    protected void shutDown() {
        if (this.config.playerOption() && this.client != null) {
            this.menuManager.removePlayerMenuItem(INVESTIGATE);
        }
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.remove((Overlay)this.screenshotOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("runewatch")) {
            return;
        }
        if (event.getKey().equals("playerOption")) {
            if (!Boolean.parseBoolean(event.getOldValue()) && Boolean.parseBoolean(event.getNewValue())) {
                this.menuManager.addPlayerMenuItem(INVESTIGATE);
            } else if (Boolean.parseBoolean(event.getOldValue()) && !Boolean.parseBoolean(event.getNewValue())) {
                this.menuManager.removePlayerMenuItem(INVESTIGATE);
            }
        } else if (event.getKey().equals("playerTextColor")) {
            this.colorAll();
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.hotKeyPressed = false;
        }
    }

    private void colorAll() {
        this.clientThread.invokeLater(() -> {
            this.colorFriendsChat();
            this.colorClanChat();
            this.colorGuestClanChat();
            this.colorRaidsSidePanel();
            this.colorRaidsPartyList();
            this.colorRaidsParty();
            this.colorTobHud();
            this.colorTobParty();
            this.colorTobPartyList();
        });
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        if (!this.config.notifyOnNearby()) {
            return;
        }
        String name = playerSpawned.getPlayer().getName();
        this.alertPlayerWarning(name, false, AlertType.NEARBY);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.menuOption() || !this.hotKeyPressed && this.config.useHotkey()) {
            return;
        }
        int groupId = RuneWatchPlugin.TO_GROUP(event.getActionParam1());
        String option = event.getOption();
        if (!MENU_WIDGET_IDS.contains(groupId) || !AFTER_OPTIONS.contains((Object)option)) {
            return;
        }
        for (MenuEntry me : this.client.getMenuEntries()) {
            if (!INVESTIGATE.equals(me.getOption())) continue;
            return;
        }
        this.client.createMenuEntry(-1).setOption(INVESTIGATE).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier());
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        Runnable color = null;
        switch (event.getScriptId()) {
            case 1658: {
                color = this::colorFriendsChat;
                break;
            }
            case 2297: {
                color = this::colorTobHud;
                break;
            }
            case 1550: {
                color = this::colorRaidsSidePanel;
            }
        }
        if (color != null) {
            this.clientThread.invokeLater(color);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        for (int gid : TRADE_SCREEN_GROUP_IDS) {
            Widget w = this.client.getWidget(gid, 0);
            if (w == null) continue;
            this.showTradeWarning(gid);
        }
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) {
        String local;
        if (!this.config.notifyOnJoin()) {
            return;
        }
        String rsn = Text.toJagexName((String)event.getMember().getName());
        if (rsn.equals(local = this.client.getLocalPlayer().getName())) {
            return;
        }
        this.alertPlayerWarning(rsn, false, AlertType.FRIENDS_CHAT);
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) {
        String local;
        if (!this.config.notifyOnJoin()) {
            return;
        }
        String rsn = Text.toJagexName((String)event.getClanMember().getName());
        if (rsn.equals(local = this.client.getLocalPlayer().getName())) {
            return;
        }
        this.alertPlayerWarning(rsn, false, AlertType.CLAN_CHAT);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int groupId = RuneWatchPlugin.TO_GROUP(event.getParam1());
        String option = event.getMenuOption();
        MenuAction action = event.getMenuAction();
        if (TRADE_SCREEN_GROUP_IDS.contains(groupId) && option.equals(DECLINE_MSG)) {
            this.clearScreenshot();
        }
        if ((action == MenuAction.RUNELITE || action == MenuAction.RUNELITE_PLAYER) && option.equals(INVESTIGATE)) {
            Player player;
            String target = action == MenuAction.RUNELITE_PLAYER ? ((player = this.client.getCachedPlayers()[event.getId()]) != null ? player.getName() : null) : Text.removeTags((String)event.getMenuTarget());
            if (target != null) {
                this.caseManager.get(event.getMenuTarget(), rwCase -> this.alertPlayerWarning(target, true, AlertType.NONE));
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        Runnable task = null;
        switch (groupId) {
            case 334: {
                task = this::takeScreenshot;
                break;
            }
            case 499: {
                task = this::colorRaidsPartyList;
                break;
            }
            case 507: {
                task = this::colorRaidsParty;
                break;
            }
            case 50: {
                task = this::colorTobParty;
                break;
            }
            case 364: {
                task = this::colorTobPartyList;
            }
        }
        if (task != null) {
            this.clientThread.invokeLater(task);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        ChatMessageType chatType = event.getType();
        if (chatType == ChatMessageType.TRADE) {
            String msg;
            switch (msg = event.getMessage()) {
                case "Accepted trade.": {
                    this.saveScreenshot();
                    break;
                }
                case "Other player declined trade.": {
                    this.clearScreenshot();
                }
            }
        }
    }

    @Schedule(period=15L, unit=ChronoUnit.MINUTES)
    public void refreshList() {
        this.caseManager.refresh(this::colorAll);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted ce) {
        if (this.developerMode && ce.getCommand().equals("rwd")) {
            this.caseManager.refresh(() -> {
                if (ce.getArguments().length > 0) {
                    this.caseManager.put(String.join((CharSequence)" ", Arrays.copyOfRange(ce.getArguments(), 1, ce.getArguments().length)), ce.getArguments()[0].toUpperCase());
                }
                this.colorAll();
            });
        } else if (ce.getCommand().equals("rw")) {
            String rsn = String.join((CharSequence)" ", ce.getArguments());
            this.caseManager.get(rsn, c -> this.alertPlayerWarning(rsn, true, AlertType.NONE));
        }
    }

    private void clearScreenshot() {
        this.tradeImage = null;
        this.trader = null;
    }

    private void takeScreenshot() {
        this.screenshotOverlay.queueForTimestamp(image -> {
            Matcher m;
            Widget nameWidget = this.client.getWidget(334, 30);
            this.trader = "unknown";
            if (nameWidget != null && (m = TRADING_WITH_PATTERN.matcher(nameWidget.getText())).matches()) {
                this.trader = m.group(2);
            }
            this.tradeImage = image;
        });
    }

    private void saveScreenshot() {
        String otherRsn = this.trader;
        Image image = this.tradeImage;
        if (this.config.screenshotTrades()) {
            this.executor.submit(() -> {
                BufferedImage screenshot = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics graphics = screenshot.getGraphics();
                int gameOffsetX = 0;
                int gameOffsetY = 0;
                graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
                this.imageCapture.saveScreenshot(screenshot, otherRsn, FOLDER_NAME, this.config.notifyWhenScreenshotTaken(), this.config.screenshotToClipboard());
            });
        } else {
            this.clearScreenshot();
        }
    }

    private void showTradeWarning(int groupId) {
        int tradeModifiedId = 31;
        int tradeModifiedMeId = 30;
        int tradingWithId = 30;
        if (groupId == 335) {
            tradeModifiedId = 29;
            tradingWithId = 31;
            tradeModifiedMeId = 26;
        }
        Widget tradeModified = this.client.getWidget(groupId, tradeModifiedId);
        Widget tradingWith = this.client.getWidget(groupId, tradingWithId);
        Widget tradeModifiedMe = this.client.getWidget(groupId, tradeModifiedMeId);
        if (tradingWith == null || tradeModified == null) {
            log.warn("no trading with widget found");
            return;
        }
        Matcher m = TRADING_WITH_PATTERN.matcher(tradingWith.getText());
        if (!m.matches()) {
            log.warn("no rsn found in trading with widget: " + tradingWith.getText());
            return;
        }
        String trader = m.group(2);
        Case rwCase = this.caseManager.get(trader);
        if (rwCase == null) {
            return;
        }
        String wText = tradeModified.getText();
        if (!wText.contains("WARNING")) {
            String warningMsg = String.format("<br>WARNING: %s is on %s list.", trader, rwCase.niceSourcePossessive());
            String msg = wText + warningMsg;
            tradeModified.setText(msg);
            if (tradeModified.getOriginalY() == tradeModifiedMe.getOriginalY()) {
                tradeModified.setOriginalY(tradeModified.getOriginalY() - 10);
                tradeModified.setOriginalX(tradeModified.getOriginalX() - 20);
            }
            tradeModified.setHidden(false);
            tradeModified.revalidate();
        }
    }

    private void alertPlayerWarning(String rsn, boolean playerExecuted, AlertType alertType) {
        rsn = Text.toJagexName((String)rsn);
        Case rwCase = this.caseManager.get(rsn);
        ChatMessageBuilder response = new ChatMessageBuilder();
        response.append(alertType.getMessage()).append(ChatColorType.HIGHLIGHT).append(rsn).append(ChatColorType.NORMAL);
        if (rwCase == null && !playerExecuted) {
            return;
        }
        if (rwCase == null) {
            response.append(" is not on any watchlist.");
        } else {
            response.append(String.format(" is on %s list for ", rwCase.niceSourcePossessive())).append(ChatColorType.HIGHLIGHT).append(rwCase.getReason());
            if (rwCase.getDate().getTime() > 0L) {
                response.append(" ").append(ChatColorType.NORMAL).append("on " + rwCase.niceDate()).append(".");
            } else {
                response.append(ChatColorType.NORMAL).append(".");
            }
            if (!playerExecuted) {
                if (this.isNotifyOnCooldown(rsn)) {
                    return;
                }
                lastNotified.put(rsn, Instant.now());
            }
        }
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response.build()).build());
    }

    boolean isNotifyOnCooldown(String rsn) {
        Instant last = lastNotified.get(rsn);
        if (last == null) {
            return false;
        }
        return last.plus((long)this.config.notificationCooldown(), ChronoUnit.MINUTES).isAfter(Instant.now());
    }

    private void colorFriendsChat() {
        Widget ccList = this.client.getWidget(458764);
        if (ccList != null) {
            this.illiteratePlayerWidgets(ccList);
        }
    }

    private void colorClanChat() {
        Widget clanChatList = this.client.getWidget(45940742);
        if (clanChatList != null) {
            this.illiteratePlayerWidgets(clanChatList);
        }
    }

    private void colorGuestClanChat() {
        Widget guestClanChatList = this.client.getWidget(45940742);
        if (guestClanChatList != null) {
            this.illiteratePlayerWidgets(guestClanChatList);
        }
    }

    private void illiteratePlayerWidgets(Widget chatWidget) {
        Widget[] players = chatWidget.getDynamicChildren();
        for (int i = 0; i < players.length; i += 3) {
            Case rwCase;
            Widget player = players[i];
            if (player == null || (rwCase = this.caseManager.get(player.getText())) == null) continue;
            player.setTextColor(this.config.playerTextColor().getRGB());
            player.revalidate();
        }
    }

    private void colorRaidsSidePanel() {
        Widget raidsList = this.client.getWidget(500, 10);
        if (raidsList != null) {
            this.colorTable(raidsList, 4);
        }
    }

    private void colorRaidsParty() {
        Widget table = this.client.getWidget(507, 11);
        if (table != null) {
            this.colorTable(table, 5);
        }
    }

    private void colorRaidsPartyList() {
        Widget list = this.client.getWidget(499, 14);
        if (list != null) {
            this.colorList(list, 3);
        }
    }

    private void colorTobHud() {
        Widget hud = this.client.getWidget(28, 9);
        if (hud == null) {
            return;
        }
        String names = hud.getText();
        if (!Strings.isNullOrEmpty((String)names)) {
            ArrayList<String> newNames = new ArrayList<String>();
            for (String name : names.split("<br>")) {
                if (name.equals("-")) {
                    newNames.add("-");
                    continue;
                }
                String stripped = Text.removeTags((String)name);
                Case rwCase = this.caseManager.get(stripped);
                if (rwCase == null) {
                    newNames.add(name);
                    continue;
                }
                String colored = new ChatMessageBuilder().append(this.config.playerTextColor(), stripped).build();
                newNames.add(colored);
            }
            hud.setText(String.join((CharSequence)"<br>", newNames));
        }
    }

    private void colorTobParty() {
        Widget table = this.client.getWidget(50, 26);
        if (table != null) {
            this.colorTable(table, 11);
        }
        if ((table = this.client.getWidget(50, 41)) != null) {
            this.colorTable(table, 18);
        }
    }

    private void colorTobPartyList() {
        Widget list = this.client.getWidget(364, 16);
        if (list != null) {
            this.colorList(list, 3);
        }
    }

    private void colorTable(Widget table, int inc) {
        Widget[] players = table.getDynamicChildren();
        for (int i = 1; i < players.length; i += inc) {
            Case rwCase;
            Widget player = players[i];
            if (player == null || (rwCase = this.caseManager.get(Text.removeTags((String)player.getText()))) == null) continue;
            player.setTextColor(this.config.playerTextColor().getRGB());
            player.setText(Text.removeTags((String)player.getText()));
            player.revalidate();
        }
    }

    private void colorList(Widget list, int nameIdx) {
        for (Widget row : list.getStaticChildren()) {
            Widget name = row.getChild(nameIdx);
            if (name == null || this.caseManager.get(name.getText()) == null) continue;
            name.setTextColor(this.config.playerTextColor().getRGB());
            name.setText(Text.removeTags((String)name.getText()));
            name.revalidate();
        }
    }

    public static int TO_GROUP(int id) {
        return id >>> 16;
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }

    private static enum AlertType {
        NONE(""),
        FRIENDS_CHAT("Friends chat member, "),
        CLAN_CHAT("Clan chat member, "),
        NEARBY("Nearby player, ");

        private final String message;

        private AlertType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

