/*
 * Decompiled with CFR 0.152.
 */
package com.runewatch;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Units;

@ConfigGroup(value="runewatch")
public interface RuneWatchConfig
extends Config {
    public static final String CONFIG_GROUP = "runewatch";
    public static final String PLAYER_OPTION = "playerOption";
    public static final String PLAYER_TEXT_COLOR = "playerTextColor";
    @ConfigSection(name="Screenshot", description="All the options for screenshot behavior", position=80)
    public static final String SCREENSHOT_SECTION = "Screenshot";
    @ConfigSection(name="Menu", description="All the options for menu behavior", position=99)
    public static final String MENU_SECTION = "Menu";
    @ConfigSection(name="Notifications", description="All the notification options", position=70)
    public static final String NOTIFICATIONS_SECTION = "Notifications";
    @ConfigSection(name="Sources", description="Configure sources for investigating reported players", position=50)
    public static final String SOURCES_SECTION = "Sources";

    @ConfigItem(position=1, keyName="screenshotTrades", name="Screenshot Trades", description="Enable screenshots on accepted trades", section="Screenshot")
    default public boolean screenshotTrades() {
        return true;
    }

    @ConfigItem(position=2, keyName="notifyWhenScreenshotTaken", name="Notify When Taken", description="Configures whether or not you are notified when a screenshot has been taken", section="Screenshot")
    default public boolean notifyWhenScreenshotTaken() {
        return true;
    }

    @ConfigItem(position=2, keyName="screenshotToClipboard", name="Upload", description="Configures whether or not screenshots are placed on your clipboard", section="Screenshot")
    default public boolean screenshotToClipboard() {
        return false;
    }

    @ConfigItem(position=3, keyName="playerOption", name="Player option", description="Add investigate option to players", section="Menu")
    default public boolean playerOption() {
        return true;
    }

    @ConfigItem(position=4, keyName="menuOption", name="Menu option", description="Show investigate option in menus", section="Menu")
    default public boolean menuOption() {
        return true;
    }

    @ConfigItem(position=5, keyName="useHotkey", name="Require Shift-Click", description="Require Shift-Right-Click to view investigate option in menus", section="Menu")
    default public boolean useHotkey() {
        return false;
    }

    @ConfigItem(position=6, keyName="playerTextColor", name="Highlight color", description="Allows you to change the color of the reported player's rsn in most player lists")
    default public Color playerTextColor() {
        return new Color(255, 77, 0);
    }

    @ConfigItem(position=7, keyName="notifyOnJoin", name="Alert On Join", description="Send an alert message when a player on the watchlist enters a Clan/Friends Chat", section="Notifications")
    default public boolean notifyOnJoin() {
        return true;
    }

    @ConfigItem(position=8, keyName="notifyOnNearby", name="Alert On Nearby", description="Send an alert message when you're nearby a player on the watch list", section="Notifications")
    default public boolean notifyOnNearby() {
        return true;
    }

    @ConfigItem(position=9, keyName="notificationCooldown", name="Cooldown", description="How many minutes should pass before re-alerting when a player is on a watch list (0 always notifies)", section="Notifications")
    @Units(value=" mins")
    default public int notificationCooldown() {
        return 60;
    }

    @ConfigItem(position=9, keyName="useRW", name="Use RuneWatch", description="Check for reported players against the RuneWatch watchlist", section="Sources")
    default public boolean useRW() {
        return true;
    }

    @ConfigItem(position=10, keyName="useWDR", name="Use We Do Raids", description="Check for reported players against the We Do Raids banlist", section="Sources")
    default public boolean useWDR() {
        return true;
    }
}

