/*
 * Decompiled with CFR 0.152.
 */
package com.runewatch;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.runewatch.Case;
import com.runewatch.RuneWatchConfig;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.Text;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CaseManager {
    private static final Logger log = LoggerFactory.getLogger(CaseManager.class);
    private static final HttpUrl RUNEWATCH_LIST_URL = HttpUrl.parse((String)"https://raw.githubusercontent.com/while-loop/runelite-plugins/runewatch-updater/mixedlist.json");
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final Type typeToken = new TypeToken<List<Case>>(){}.getType();
    private final OkHttpClient client;
    private final Gson gson;
    private final Map<String, Case> rwCases = new ConcurrentHashMap<String, Case>();
    private final Map<String, Case> wdrCases = new ConcurrentHashMap<String, Case>();
    private final ClientThread clientThread;
    private final RuneWatchConfig config;

    @Inject
    private CaseManager(OkHttpClient client, ClientThread clientThread, RuneWatchConfig config, Gson gson) {
        this.client = client;
        this.clientThread = clientThread;
        this.config = config;
        this.gson = gson.newBuilder().registerTypeAdapter(Date.class, (json, typeOfT, context) -> {
            try {
                return df.parse(json.getAsString());
            }
            catch (ParseException e) {
                return Date.from(Instant.ofEpochSecond(0L));
            }
        }).create();
    }

    public void refresh(final Runnable onComplete) {
        Request rwReq = new Request.Builder().url(RUNEWATCH_LIST_URL).build();
        this.client.newCall(rwReq).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("failed to get runewatch list: {}", (Object)e.toString());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (response.code() < 200 || response.code() >= 400) {
                        log.error("failed to get watchlist. status: {}", (Object)response.code());
                    } else {
                        List cases = (List)CaseManager.this.gson.fromJson((Reader)new InputStreamReader(response.body().byteStream()), typeToken);
                        CaseManager.this.rwCases.clear();
                        CaseManager.this.wdrCases.clear();
                        for (Case c : cases) {
                            String rsn = c.getRsn().toLowerCase();
                            Map<String, Case> sourceCases = c.getSource().toLowerCase().equals("wdr") ? CaseManager.this.wdrCases : CaseManager.this.rwCases;
                            Case old = sourceCases.get(rsn);
                            if (old != null && !old.getDate().before(c.getDate())) continue;
                            sourceCases.put(rsn, c);
                        }
                        log.debug("saved {}/{} rw cases", (Object)CaseManager.this.rwCases.size(), (Object)cases.size());
                        log.debug("saved {}/{} wdr cases", (Object)CaseManager.this.wdrCases.size(), (Object)cases.size());
                    }
                }
                finally {
                    response.close();
                    if (onComplete != null) {
                        CaseManager.this.clientThread.invokeLater(onComplete);
                    }
                }
            }
        });
    }

    public Case get(String rsn) {
        Case c;
        String cleanRsn = Text.removeTags((String)Text.toJagexName((String)rsn)).toLowerCase();
        if (this.config.useRW() && (c = this.rwCases.get(cleanRsn)) != null) {
            return c;
        }
        if (this.config.useWDR() && (c = this.wdrCases.get(cleanRsn)) != null) {
            return c;
        }
        return null;
    }

    public void get(String rsn, Consumer<Case> onComplete) {
        this.refresh(() -> onComplete.accept(this.get(rsn)));
    }

    void put(String rsn, String source) {
        if (source.toLowerCase().equals("rw")) {
            this.rwCases.put(rsn.toLowerCase(), new Case(rsn, new Date(), "aaa", "debugging", "3", source));
        } else {
            this.wdrCases.put(rsn.toLowerCase(), new Case(rsn, new Date(), "aaa", "debugging", "3", source));
        }
    }
}

