/*
 * Decompiled with CFR 0.152.
 */
package com.runewatch;

import com.google.gson.annotations.SerializedName;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Case {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MMM d, yyyy");
    @SerializedName(value="accused_rsn")
    private String rsn;
    @SerializedName(value="published_date")
    private Date date;
    @SerializedName(value="short_code")
    private String code;
    private String reason;
    @SerializedName(value="evidence_rating")
    private String rating;
    @SerializedName(value="source")
    private String source;

    public String niceDate() {
        return this.date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(DATE_FORMAT);
    }

    public String getSource() {
        return this.source == null ? "RW" : this.source;
    }

    public boolean isRW() {
        return !this.getSource().toLowerCase().equals("wdr");
    }

    public String niceSourcePossessive() {
        switch (this.getSource().toLowerCase()) {
            case "rw": {
                return "RuneWatch's";
            }
            case "wdr": {
                return "We Do Raids'";
            }
        }
        return "Unknown's";
    }

    public String getRsn() {
        return this.rsn;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRsn(String rsn) {
        this.rsn = rsn;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Case)) {
            return false;
        }
        Case other = (Case)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rsn = this.getRsn();
        String other$rsn = other.getRsn();
        if (this$rsn == null ? other$rsn != null : !this$rsn.equals(other$rsn)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$rating = this.getRating();
        String other$rating = other.getRating();
        if (this$rating == null ? other$rating != null : !this$rating.equals(other$rating)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Case;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rsn = this.getRsn();
        result = result * 59 + ($rsn == null ? 43 : $rsn.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $rating = this.getRating();
        result = result * 59 + ($rating == null ? 43 : $rating.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String toString() {
        return "Case(rsn=" + this.getRsn() + ", date=" + this.getDate() + ", code=" + this.getCode() + ", reason=" + this.getReason() + ", rating=" + this.getRating() + ", source=" + this.getSource() + ")";
    }

    public Case(String rsn, Date date, String code, String reason, String rating, String source) {
        this.rsn = rsn;
        this.date = date;
        this.code = code;
        this.reason = reason;
        this.rating = rating;
        this.source = source;
    }
}

