/*
 * Decompiled with CFR 0.152.
 */
package com.protje.osrsplayercount.scraper;

import com.google.inject.Inject;
import com.protje.osrsplayercount.OsrsPlayerCountConfig;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.client.RuneLite;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsrsPlayerCountWebScraper {
    private static final Logger log = LoggerFactory.getLogger(OsrsPlayerCountWebScraper.class);
    static final String OSRS_HOMEPAGE_URL = "https://oldschool.runescape.com/";
    static final Pattern OSRS_PLAYER_COUNT_PATTERN = Pattern.compile("<p class='player-count'>There are currently ([\\d,]+) people playing!</p>", 32);
    static final String USER_AGENT = RuneLite.USER_AGENT + " (osrs-player-count)";
    @Inject
    private OsrsPlayerCountConfig config;
    @Inject
    private OkHttpClient httpClient;
    private String playerCount = "-";
    private long lastCheckedTime;

    public String getPlayerCount() {
        if (this.getTimestamp() - this.lastCheckedTime >= (long)(this.config.refreshInterval() * 1000)) {
            CompletableFuture.runAsync(this.extractPlayerCountFromHTML());
            this.lastCheckedTime = this.getTimestamp();
        }
        return this.playerCount;
    }

    private long getTimestamp() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return timestamp.getTime();
    }

    private Runnable extractPlayerCountFromHTML() {
        return () -> {
            String content;
            Request request = new Request.Builder().url(OSRS_HOMEPAGE_URL).header("User-Agent", USER_AGENT).build();
            try {
                Response response = this.httpClient.newCall(request).execute();
                content = response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Matcher m = OSRS_PLAYER_COUNT_PATTERN.matcher(content);
            if (m.find()) {
                log.debug("Scraped OSRS homepage player count");
                this.playerCount = m.group(1);
            } else {
                log.error("Failed to scrape OSRS homepage player count");
                this.playerCount = "-";
            }
        };
    }
}

