/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.TileObject;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.MotherlodeInventory;
import tictac7x.motherlode.MotherlodeObjectsOverlay;
import tictac7x.motherlode.MotherlodeRockfallsOverlay;
import tictac7x.motherlode.MotherlodeSack;
import tictac7x.motherlode.MotherlodeSackWidget;
import tictac7x.motherlode.MotherlodeVeins;
import tictac7x.motherlode.MotherlodeVeinsOverlay;

@PluginDescriptor(name="Motherlode Mine Improved", description="Better indicators for ore veins", tags={"motherlode", "prospector", "golden", "nugget"})
public class TicTac7xMotherlodePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TicTac7xMotherlodePlugin.class);
    @Inject
    private Client client;
    @Inject
    private MotherlodeConfig config;
    @Inject
    private OverlayManager overlays;
    @Inject
    private ClientThread client_thread;
    private Motherlode motherlode;
    private MotherlodeInventory inventory;
    private MotherlodeSack sack;
    private MotherlodeVeins veins;
    private MotherlodeSackWidget widget_sack;
    private MotherlodeVeinsOverlay overlay_veins;
    private MotherlodeRockfallsOverlay overlay_rockfalls;
    private MotherlodeObjectsOverlay overlay_objects;

    @Provides
    MotherlodeConfig provideConfig(ConfigManager configManager) {
        return (MotherlodeConfig)configManager.getConfig(MotherlodeConfig.class);
    }

    protected void startUp() {
        if (this.motherlode == null) {
            this.motherlode = new Motherlode(this.client, this.config);
            this.inventory = this.motherlode.getInventory();
            this.sack = this.motherlode.getSack();
            this.veins = this.motherlode.getVeins();
            this.overlay_veins = new MotherlodeVeinsOverlay(this.config, this.motherlode, this.client);
            this.widget_sack = new MotherlodeSackWidget(this.config, this.motherlode, this.client);
            this.overlay_rockfalls = new MotherlodeRockfallsOverlay(this.config, this.motherlode, this.client);
            this.overlay_objects = new MotherlodeObjectsOverlay(this.config, this.motherlode);
        }
        this.client_thread.invokeLater(() -> {
            this.widget_sack.loadNativeWidget();
            this.motherlode.updatePayDirtNeeded();
        });
        this.overlays.add((Overlay)this.overlay_veins);
        this.overlays.add((Overlay)this.overlay_rockfalls);
        this.overlays.add((Overlay)this.overlay_objects);
        this.overlays.add((Overlay)this.widget_sack);
    }

    protected void shutDown() {
        this.overlay_veins.clear();
        this.widget_sack.updateMotherlodeNativeWidget(false);
        this.overlay_rockfalls.clear();
        this.overlays.remove((Overlay)this.overlay_veins);
        this.overlays.remove((Overlay)this.overlay_rockfalls);
        this.overlays.remove((Overlay)this.overlay_objects);
        this.overlays.remove((Overlay)this.widget_sack);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.overlay_veins.onTileObjectSpawned((TileObject)event.getGameObject());
        this.overlay_rockfalls.onTileObjectSpawned((TileObject)event.getGameObject());
        this.overlay_objects.onTileObjectSpawned((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.overlay_veins.onTileObjectDespawned((TileObject)event.getGameObject());
        this.overlay_rockfalls.onTileObjectDespawned((TileObject)event.getGameObject());
        this.overlay_objects.onTileObjectDespawned((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.overlay_objects.onTileObjectSpawned((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.overlay_objects.onTileObjectDespawned((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.veins.onTileObjectSpawned((TileObject)event.getWallObject());
        this.overlay_veins.onTileObjectSpawned((TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.veins.onTileObjectDespawned((TileObject)event.getWallObject());
        this.overlay_veins.onTileObjectDespawned((TileObject)event.getWallObject());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.motherlode.onGameStateChanged(event);
        this.overlay_veins.onGameStateChanged(event);
        this.overlay_rockfalls.onGameStateChanged(event);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.motherlode.onGameTick();
        this.sack.onGameTick();
        this.veins.onGameTick();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.sack.onVarbitChanged();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.client_thread.invokeLater(() -> this.widget_sack.onWidgetLoaded(event));
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.inventory.onItemContainerChanged(event);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.motherlode.onConfigChanged(event);
        this.widget_sack.onConfigChanged(event);
    }
}

