/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.MotherlodeInventory;
import tictac7x.motherlode.MotherlodeSack;
import tictac7x.motherlode.MotherlodeVeins;
import tictac7x.motherlode.OreVein;
import tictac7x.motherlode.Sector;

public class MotherlodeVeinsOverlay
extends Overlay {
    private final MotherlodeConfig config;
    private final Motherlode motherlode;
    private final MotherlodeVeins veins;
    private final MotherlodeInventory inventory;
    private final MotherlodeSack sack;
    private final Client client;
    private final Set<TileObject> ore_veins = new HashSet<TileObject>();

    public MotherlodeVeinsOverlay(MotherlodeConfig config, Motherlode motherlode, Client client) {
        this.config = config;
        this.motherlode = motherlode;
        this.inventory = motherlode.getInventory();
        this.sack = motherlode.getSack();
        this.veins = motherlode.getVeins();
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void onTileObjectSpawned(TileObject object) {
        if (this.motherlode.inRegion() && (this.veins.isOreVein(object) || this.veins.isOreVeinDepleted(object))) {
            this.ore_veins.add(object);
        }
    }

    public void onTileObjectDespawned(TileObject object) {
        if (this.motherlode.inRegion() && (this.veins.isOreVein(object) || this.veins.isOreVeinDepleted(object))) {
            this.ore_veins.remove(object);
        }
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.clear();
        }
    }

    public void clear() {
        this.ore_veins.clear();
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.motherlode.inRegion()) {
            return null;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        int pay_dirt_needed = this.motherlode.getPayDirtNeeded();
        int inventory_pay_dirt = this.inventory.countPayDirt();
        if (pay_dirt_needed == 0 && this.inventory.countItems() == this.inventory.getSize()) {
            return null;
        }
        if (this.sack.shouldBeEmptied()) {
            return null;
        }
        for (TileObject ore_vein : this.ore_veins) {
            OreVein vein = this.veins.getOreVein(ore_vein);
            if (vein == null || this.config.upstairsOnly() && vein.sector == Sector.DOWNSTAIRS) continue;
            if (vein.isDepleted()) {
                if (!this.motherlode.getPlayerSectors().contains((Object)vein.sector) || player.getLocalLocation().distanceTo(ore_vein.getLocalLocation()) > this.config.getDrawDistance()) continue;
                if (pay_dirt_needed == 0 && this.inventory.countItems() != this.inventory.getSize() || pay_dirt_needed < 0) {
                    this.renderPie(graphics, ore_vein, this.config.getOreVeinsStoppingColor(), this.veins.getOreVeinProgress(ore_vein));
                    continue;
                }
                if (!this.motherlode.needToMine()) continue;
                this.renderPie(graphics, ore_vein, this.config.getOreVeinsDepletedColor(), this.veins.getOreVeinProgress(ore_vein));
                continue;
            }
            if (!this.motherlode.getPlayerSectors().contains((Object)vein.sector) || player.getLocalLocation().distanceTo(ore_vein.getLocalLocation()) > this.config.getDrawDistance()) continue;
            if (pay_dirt_needed == 0 && this.inventory.countItems() != this.inventory.getSize() || pay_dirt_needed < 0) {
                this.renderPie(graphics, ore_vein, this.config.getOreVeinsStoppingColor(), 1.0f);
                continue;
            }
            if (!this.motherlode.needToMine()) continue;
            this.renderPie(graphics, ore_vein, this.config.getOreVeinsColor(), 1.0f);
        }
        return null;
    }

    private void renderPie(Graphics2D graphics, TileObject object, Color color, float progress) {
        if (color.getAlpha() == 0) {
            return;
        }
        try {
            ProgressPieComponent progressPieComponent = new ProgressPieComponent();
            progressPieComponent.setPosition(object.getCanvasLocation(150));
            progressPieComponent.setProgress((double)(-progress));
            progressPieComponent.setBorderColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(255, color.getAlpha() + 20)));
            progressPieComponent.setFill(color);
            progressPieComponent.render(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

