/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.runelite.api.TileObject;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.OreVein;
import tictac7x.motherlode.Sector;

public class MotherlodeVeins {
    private final Motherlode motherlode;
    private final Set<Integer> ORE_VEINS = ImmutableSet.of((Object)26661, (Object)26662, (Object)26663, (Object)26664);
    private final Set<Integer> ORE_VEINS_DEPLETED = ImmutableSet.of((Object)26665, (Object)26666, (Object)26667, (Object)26668);
    private final int ORE_VEIN_RESPAWN = 180;
    private final Set<OreVein> ore_veins = new HashSet<OreVein>();

    public MotherlodeVeins(Motherlode motherlode) {
        this.motherlode = motherlode;
    }

    public void onTileObjectSpawned(TileObject object) {
        if (!this.motherlode.inRegion()) {
            return;
        }
        if (this.isOreVein(object) || this.isOreVeinDepleted(object)) {
            boolean depleted = this.isOreVeinDepleted(object);
            int x = object.getWorldLocation().getX();
            int y = object.getWorldLocation().getY();
            Optional<OreVein> ore_vein = this.ore_veins.stream().filter(ore_vein_depleted -> ore_vein_depleted.x == x && ore_vein_depleted.y == y).findAny();
            if (ore_vein.isPresent()) {
                ore_vein.get().setDepleted(depleted);
                ore_vein.get().resetGameTicks();
            } else {
                List<Sector> sectors = this.motherlode.getSectors(x, y, false);
                if (sectors.size() > 0) {
                    this.ore_veins.add(new OreVein(x, y, sectors.get(0), depleted));
                }
            }
        }
    }

    public void onTileObjectDespawned(TileObject object) {
        if (!this.motherlode.inRegion()) {
            return;
        }
        if (this.isOreVeinDepleted(object)) {
            this.ore_veins.stream().filter(ore_vein_depleted -> object.getWorldLocation().getX() == ore_vein_depleted.x && object.getWorldLocation().getY() == ore_vein_depleted.y).findAny().ifPresent(this.ore_veins::remove);
        }
    }

    public void onGameTick() {
        if (!this.motherlode.inRegion()) {
            return;
        }
        this.ore_veins.stream().filter(ore_vein -> ore_vein.isDepleted()).forEach(OreVein::onGameTick);
    }

    public boolean isOreVein(TileObject object) {
        return this.ORE_VEINS.contains(object.getId());
    }

    public boolean isOreVeinDepleted(TileObject object) {
        return this.ORE_VEINS_DEPLETED.contains(object.getId());
    }

    public float getOreVeinProgress(TileObject object) {
        Optional<OreVein> ore_vein = this.ore_veins.stream().filter(ore_vein_depleted -> object.getWorldLocation().getX() == ore_vein_depleted.x && object.getWorldLocation().getY() == ore_vein_depleted.y).findAny();
        return ore_vein.isPresent() ? (float)(-ore_vein.get().getGameTicks()) / 180.0f : 1.0f;
    }

    @Nullable
    public OreVein getOreVein(TileObject object) {
        return this.ore_veins.stream().filter(ore_vein -> object.getWorldLocation().getX() == ore_vein.x && object.getWorldLocation().getY() == ore_vein.y).findAny().orElse(null);
    }
}

