/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.MotherlodeInventory;
import tictac7x.motherlode.MotherlodeSack;

public class MotherlodeSackWidget
extends OverlayPanel {
    private final MotherlodeConfig config;
    private final Motherlode motherlode;
    private final Client client;
    private final MotherlodeSack sack;
    private final MotherlodeInventory inventory;
    private final PanelComponent panel = new PanelComponent();
    @Nullable
    private Widget widget = null;

    public MotherlodeSackWidget(MotherlodeConfig config, Motherlode motherlode, Client client) {
        this.config = config;
        this.motherlode = motherlode;
        this.client = client;
        this.sack = motherlode.getSack();
        this.inventory = motherlode.getInventory();
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.panelComponent.setBorder(new Rectangle(0, 0, 0, 0));
    }

    public void loadNativeWidget() {
        Widget widget = this.client.getWidget(WidgetInfo.MOTHERLODE_MINE);
        if (widget != null) {
            this.widget = widget;
            this.updateMotherlodeNativeWidget(this.config.showSackPaydirt() || this.config.showSackNeeded() || this.config.showSackDeposits());
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == WidgetInfo.MOTHERLODE_MINE.getGroupId()) {
            this.loadNativeWidget();
        }
    }

    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tictac7x-motherlode")) {
            this.updateMotherlodeNativeWidget(this.config.showSackPaydirt() || this.config.showSackNeeded() || this.config.showSackDeposits());
        }
    }

    public void updateMotherlodeNativeWidget(boolean hidden) {
        if (this.widget != null) {
            this.widget.setHidden(hidden);
        }
    }

    private int getTotalPayDirtCount() {
        return this.inventory.countPayDirt() + this.sack.countPayDirt();
    }

    private boolean isPayDirtTotalPerfect(int pay_dirt_needed) {
        return this.getTotalPayDirtCount() == this.sack.getSize() && this.inventory.countPayDirt() != 0 || this.sack.countPayDirt() == this.sack.getSize() && this.inventory.countPayDirt() == this.inventory.getSize() || this.sack.countPayDirt() == this.sack.getSize() && pay_dirt_needed == 0;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.motherlode.inRegion() || !this.config.showSackDeposits() && !this.config.showSackNeeded() && !this.config.showSackPaydirt()) {
            return null;
        }
        int pay_dirt_needed = this.motherlode.getPayDirtNeeded();
        int deposits_left = this.motherlode.getDepositsLeft();
        this.panelComponent.getChildren().clear();
        this.panel.getChildren().clear();
        Color color_background = this.isPayDirtTotalPerfect(pay_dirt_needed) || pay_dirt_needed == 0 && this.inventory.countPayDirt() > 0 ? Color.green : (this.sack.isFull() || pay_dirt_needed < 0 ? Color.red : (this.sack.shouldBeEmptied() ? Color.orange : null));
        this.panel.setBackgroundColor(color_background == null ? null : new Color(color_background.getRed(), color_background.getGreen(), color_background.getBlue(), 80));
        if (this.config.showSackPaydirt()) {
            this.panel.getChildren().add(LineComponent.builder().left("Sack:").leftColor(color_background != null ? Color.white : Color.lightGray).right(String.valueOf(this.sack.countPayDirt())).rightColor(Color.white).build());
        }
        if (this.config.showSackDeposits()) {
            this.panel.getChildren().add(LineComponent.builder().left("Deposits:").leftColor(color_background != null ? Color.white : Color.lightGray).right(String.valueOf(deposits_left)).rightColor(Color.white).build());
        }
        if (this.config.showSackNeeded()) {
            Color color_needed = color_background != null || pay_dirt_needed == 0 ? Color.white : Color.green;
            this.panel.getChildren().add(LineComponent.builder().left("Needed:").leftColor(color_background != null ? Color.white : Color.orange).right(String.valueOf(pay_dirt_needed)).rightColor(color_needed).build());
        }
        this.panelComponent.getChildren().add(this.panel);
        return super.render(graphics);
    }
}

