/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import net.runelite.api.Client;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeInventory;

public class MotherlodeSack {
    private final Motherlode motherlode;
    private final MotherlodeInventory inventory;
    private final Client client;
    private final int VARBIT_SACK_UPGRADED = 5556;
    private final int VARBIT_SACK_PAY_DIRT = 5558;
    private final int SACK_SIZE_DEFAULT = 80;
    private final int SACK_SIZE_UPGRADED = 161;
    private final int ANIMATION_HOPPER_DEPOSIT = 832;
    private int sack_pay_dirt = 0;
    private int hopper_pay_dirt = 0;
    private boolean upgraded = false;
    private boolean should_be_emptied = false;

    public MotherlodeSack(Motherlode motherlode, MotherlodeInventory inventory, Client client) {
        this.motherlode = motherlode;
        this.inventory = inventory;
        this.client = client;
    }

    public void onVarbitChanged() {
        if (!this.motherlode.inRegion()) {
            return;
        }
        this.updateSackUpgrade();
        this.updateSackPayDirt();
    }

    public void onGameTick() {
        if (!this.motherlode.inRegion()) {
            return;
        }
        if (this.hopper_pay_dirt == 0 && this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getAnimation() == 832) {
            this.hopper_pay_dirt += Math.max(this.inventory.countPayDirt(), this.inventory.countPayDirtOld());
            this.motherlode.updatePayDirtNeeded();
        }
    }

    public int countPayDirt() {
        return this.sack_pay_dirt + this.hopper_pay_dirt;
    }

    public int getSize() {
        return this.upgraded ? 161 : 80;
    }

    public boolean isFullActual() {
        return this.sack_pay_dirt > this.getSize();
    }

    public boolean isFull() {
        return this.countPayDirt() > this.getSize();
    }

    public boolean shouldBeEmptied() {
        return this.should_be_emptied;
    }

    private void updateSackUpgrade() {
        this.upgraded = this.client.getVarbitValue(5556) == 1;
    }

    private void updateSackPayDirt() {
        int sack_pay_dirt = this.client.getVarbitValue(5558);
        if (sack_pay_dirt != this.sack_pay_dirt) {
            this.sack_pay_dirt = sack_pay_dirt;
            this.hopper_pay_dirt = 0;
            this.motherlode.updatePayDirtNeeded();
            if (this.isFullActual()) {
                this.should_be_emptied = true;
            } else if (this.sack_pay_dirt == 0) {
                this.should_be_emptied = false;
            }
        }
    }
}

