/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import com.google.common.collect.ImmutableSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.Rockfall;
import tictac7x.motherlode.Sector;

public class MotherlodeRockfallsOverlay
extends Overlay {
    private final MotherlodeConfig config;
    private final Motherlode motherlode;
    private final Client client;
    private final Set<Integer> ROCKFALLS = ImmutableSet.of((Object)26679, (Object)26680);
    private final Set<TileObject> rockfalls = new HashSet<TileObject>();

    public MotherlodeRockfallsOverlay(MotherlodeConfig config, Motherlode motherlode, Client client) {
        this.config = config;
        this.motherlode = motherlode;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void onTileObjectSpawned(TileObject object) {
        if (this.motherlode.inRegion() && this.ROCKFALLS.contains(object.getId())) {
            this.rockfalls.add(object);
        }
    }

    public void onTileObjectDespawned(TileObject object) {
        if (this.motherlode.inRegion() && this.ROCKFALLS.contains(object.getId())) {
            this.rockfalls.remove(object);
        }
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.clear();
        }
    }

    public void clear() {
        this.rockfalls.clear();
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.motherlode.inRegion()) {
            return null;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null || this.motherlode.getSack().shouldBeEmptied()) {
            return null;
        }
        block0: for (TileObject rockfall : this.rockfalls) {
            Optional<Rockfall> rockfall_predefined = this.motherlode.getRockfalls().getRockfalls().stream().filter(rock -> rockfall.getWorldLocation().getX() == rock.x && rockfall.getWorldLocation().getY() == rock.y).findAny();
            if (this.config.upstairsOnly() && !rockfall_predefined.isPresent()) continue;
            if (rockfall_predefined.isPresent() && this.motherlode.getPlayerSectors() != null) {
                for (Sector sector : rockfall_predefined.get().sectors) {
                    if (!this.motherlode.getPlayerSectors().contains((Object)sector)) continue;
                    this.renderTile(graphics, rockfall, this.config.getRockfallsColor());
                    continue block0;
                }
                continue;
            }
            if (rockfall_predefined.isPresent() || !this.motherlode.isDownStairs() || player.getLocalLocation().distanceTo(rockfall.getLocalLocation()) > this.config.getDrawDistance()) continue;
            this.renderTile(graphics, rockfall, this.config.getRockfallsColor());
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, TileObject tile_object, Color color) {
        if (color.getAlpha() == 0) {
            return;
        }
        try {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(255, color.getAlpha() + 20)));
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(tile_object.getCanvasTilePoly());
            graphics.setColor(color);
            graphics.fill(tile_object.getCanvasTilePoly());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

