/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import tictac7x.motherlode.Motherlode;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.MotherlodeInventory;
import tictac7x.motherlode.MotherlodeSack;

public class MotherlodeObjectsOverlay
extends Overlay {
    private final MotherlodeConfig config;
    private final Motherlode motherlode;
    private final MotherlodeInventory inventory;
    private final MotherlodeSack motherlode_sack;
    private final int LADDER_UP = 19045;
    private final int LADDER_DOWN = 19044;
    private final int CRATE = 357;
    private final int CRATE_X = 3752;
    private final int CRATE_Y = 5674;
    private final int HOPPER = 26674;
    private final int BROKEN_STRUT = 26670;
    private final int SACK = 26688;
    private TileObject ladder_up;
    private TileObject ladder_down;
    private TileObject crate;
    private TileObject hopper;
    private TileObject sack;
    private final Set<TileObject> broken_struts = new HashSet<TileObject>();

    public MotherlodeObjectsOverlay(MotherlodeConfig config, Motherlode motherlode) {
        this.config = config;
        this.motherlode = motherlode;
        this.inventory = motherlode.getInventory();
        this.motherlode_sack = motherlode.getSack();
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void onTileObjectSpawned(TileObject object) {
        int id = object.getId();
        if (id == 19045) {
            this.ladder_up = object;
        } else if (id == 19044) {
            this.ladder_down = object;
        } else if (id == 357 && object.getWorldLocation().getX() == 3752 && object.getWorldLocation().getY() == 5674) {
            this.crate = object;
        } else if (id == 26674) {
            this.hopper = object;
        } else if (id == 26670) {
            this.broken_struts.add(object);
        } else if (id == 26688) {
            this.sack = object;
        }
    }

    public void onTileObjectDespawned(TileObject object) {
        int id = object.getId();
        if (id == 26670) {
            this.broken_struts.remove(object);
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.motherlode.inRegion()) {
            return null;
        }
        int pay_dirt_needed = this.motherlode.getPayDirtNeeded();
        if (this.ladder_down != null && this.motherlode.isDownStairs()) {
            if (this.motherlode.needToMine()) {
                this.renderClickbox(graphics, this.ladder_down, this.config.getOreVeinsColor());
            } else if (this.motherlode.needToDepositPayDirt()) {
                this.renderClickbox(graphics, this.ladder_down, this.config.getOreVeinsDepletedColor());
            }
        }
        if (this.ladder_up != null && (this.motherlode.needToDepositPayDirt() || pay_dirt_needed < 0) && this.motherlode.isUpstairs()) {
            if (pay_dirt_needed == 0) {
                this.renderClickbox(graphics, this.ladder_up, this.config.getOreVeinsColor());
            } else if (pay_dirt_needed < 0) {
                this.renderClickbox(graphics, this.ladder_up, this.config.getOreVeinsStoppingColor());
            }
        } else if (this.ladder_up != null && pay_dirt_needed > 0 && this.motherlode.isUpstairs()) {
            this.renderClickbox(graphics, this.ladder_up, this.config.getOreVeinsDepletedColor());
        }
        if (this.crate != null && pay_dirt_needed == 0 && this.inventory.countPayDirt() > 0 && this.motherlode_sack.isFull() && this.motherlode.isDownStairs() && this.broken_struts.size() == 2) {
            this.renderClickbox(graphics, this.crate, this.config.getOreVeinsColor());
        }
        if (this.hopper != null && this.inventory.countPayDirt() > 0) {
            if (pay_dirt_needed < 0) {
                this.renderClickbox(graphics, this.hopper, this.config.getOreVeinsStoppingColor());
            } else if (pay_dirt_needed == 0) {
                if (this.motherlode.isDownStairs()) {
                    this.renderClickbox(graphics, this.hopper, this.config.getOreVeinsColor());
                } else {
                    this.renderClickbox(graphics, this.hopper, this.config.getOreVeinsDepletedColor());
                }
            }
        }
        if (this.sack != null && this.motherlode_sack.shouldBeEmptied()) {
            if (this.motherlode.isDownStairs()) {
                this.renderClickbox(graphics, this.sack, this.config.getOreVeinsColor());
            } else {
                this.renderClickbox(graphics, this.sack, this.config.getOreVeinsDepletedColor());
            }
        }
        if (this.motherlode_sack.isFull() && !this.motherlode_sack.isFullActual() && this.motherlode.isDownStairs()) {
            for (TileObject broken_strut : this.broken_struts) {
                if (this.broken_struts.size() == 1) {
                    this.renderClickbox(graphics, broken_strut, this.config.getOreVeinsDepletedColor());
                    continue;
                }
                this.renderClickbox(graphics, broken_strut, this.config.getOreVeinsStoppingColor());
            }
        }
        return null;
    }

    private void renderClickbox(Graphics2D graphics, TileObject tile_object, Color color) {
        if (color.getAlpha() == 0) {
            return;
        }
        try {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(255, color.getAlpha() + 20)));
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(tile_object.getClickbox());
            graphics.setColor(color);
            graphics.fill(tile_object.getClickbox());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

