/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.motherlode;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.events.ConfigChanged;
import tictac7x.motherlode.MotherlodeConfig;
import tictac7x.motherlode.MotherlodeInventory;
import tictac7x.motherlode.MotherlodeRockfalls;
import tictac7x.motherlode.MotherlodeSack;
import tictac7x.motherlode.MotherlodeVeins;
import tictac7x.motherlode.Sector;

public class Motherlode {
    private final Client client;
    private final MotherlodeConfig config;
    private final MotherlodeInventory inventory;
    private final MotherlodeSack sack;
    private final MotherlodeVeins veins;
    private final MotherlodeRockfalls rockfalls;
    private final Set<Integer> REGIONS = ImmutableSet.of((Object)14679, (Object)14680, (Object)14681, (Object)14935, (Object)14936, (Object)14937, (Object[])new Integer[]{15191, 15192, 15193});
    private boolean in_region = false;
    private int pay_dirt_needed = 0;
    private int deposits_left = 0;
    private List<Sector> player_sector = new ArrayList<Sector>();
    @Nullable
    private Integer player_x = null;
    @Nullable
    private Integer player_y = null;
    private final int[][] UPSTAIRS_W = new int[][]{{3734, 5685}, {3735, 5684}, {3735, 5685}, {3735, 5686}, {3736, 5685}, {3737, 5682}, {3737, 5683}, {3737, 5684}, {3737, 5685}, {3738, 5682}, {3738, 5683}, {3738, 5684}, {3738, 5685}, {3739, 5683}, {3739, 5684}, {3739, 5685}, {3740, 5684}, {3740, 5685}, {3740, 5686}, {3741, 5683}, {3741, 5684}, {3741, 5685}, {3741, 5686}, {3742, 5683}, {3742, 5684}, {3742, 5685}, {3742, 5686}, {3743, 5684}, {3743, 5686}, {3743, 5687}, {3744, 5686}, {3744, 5687}, {3745, 5684}, {3745, 5685}, {3745, 5686}, {3746, 5684}, {3746, 5685}, {3746, 5686}, {3747, 5685}, {3747, 5686}, {3748, 5684}, {3748, 5685}};
    private final int[][] UPSTAIRS_NW = new int[][]{{3747, 5683}, {3748, 5682}, {3748, 5683}, {3748, 5684}, {3749, 5682}, {3749, 5683}, {3749, 5684}, {3750, 5682}, {3750, 5683}, {3750, 5684}, {3750, 5685}, {3751, 5678}, {3751, 5680}, {3751, 5681}, {3751, 5683}, {3751, 5684}, {3752, 5676}, {3752, 5677}, {3752, 5678}, {3752, 5679}, {3752, 5680}, {3752, 5681}, {3752, 5682}, {3752, 5683}, {3752, 5684}, {3753, 5676}, {3753, 5677}, {3753, 5678}, {3753, 5680}, {3753, 5682}, {3753, 5683}, {3753, 5684}, {3754, 5675}, {3754, 5676}, {3754, 5678}, {3754, 5682}, {3754, 5683}, {3755, 5675}, {3755, 5676}, {3755, 5677}};
    private final int[][] UPSTAIRS_SE = new int[][]{{3755, 5675}, {3755, 5676}, {3756, 5674}, {3756, 5675}, {3756, 5676}, {3757, 5673}, {3757, 5674}, {3757, 5675}, {3757, 5676}, {3758, 5673}, {3758, 5675}, {3759, 5672}, {3759, 5673}, {3759, 5674}, {3760, 5671}, {3760, 5672}, {3760, 5673}, {3760, 5674}, {3761, 5668}, {3761, 5669}, {3761, 5670}, {3761, 5671}, {3761, 5672}, {3761, 5673}, {3761, 5674}, {3762, 5668}, {3762, 5670}, {3762, 5671}, {3762, 5672}, {3762, 5673}};
    private final int[][] UPSTAIRS_S = new int[][]{{3761, 5660}, {3761, 5661}, {3761, 5662}, {3761, 5663}, {3761, 5664}, {3762, 5657}, {3762, 5658}, {3762, 5660}, {3762, 5661}, {3762, 5662}, {3762, 5663}, {3762, 5664}, {3762, 5665}, {3762, 5667}, {3762, 5668}, {3763, 5656}, {3763, 5657}, {3763, 5658}, {3763, 5659}, {3763, 5660}, {3763, 5662}, {3763, 5663}, {3763, 5665}, {3763, 5666}, {3763, 5667}, {3763, 5668}, {3763, 5670}, {3764, 5656}, {3764, 5657}, {3764, 5658}, {3764, 5659}, {3764, 5665}, {3764, 5667}, {3764, 5668}, {3764, 5669}, {3764, 5670}, {3765, 5656}, {3765, 5657}, {3765, 5658}, {3766, 5657}};
    private final int[][] UPSTAIRS_NE = new int[][]{{3755, 5681}, {3755, 5682}, {3755, 5683}, {3756, 5678}, {3756, 5679}, {3756, 5681}, {3756, 5682}, {3756, 5683}, {3756, 5684}, {3757, 5677}, {3757, 5678}, {3757, 5679}, {3757, 5680}, {3757, 5681}, {3757, 5682}, {3757, 5683}, {3757, 5684}, {3758, 5680}, {3758, 5681}, {3758, 5683}, {3758, 5685}, {3759, 5682}, {3759, 5683}, {3759, 5684}, {3759, 5685}, {3760, 5683}, {3760, 5684}, {3760, 5685}, {3761, 5681}, {3761, 5682}, {3761, 5683}, {3761, 5684}, {3761, 5685}, {3762, 5682}, {3762, 5683}};
    private final int[][] UPSTAIRS_E = new int[][]{{3757, 5677}, {3758, 5677}, {3758, 5678}, {3759, 5676}, {3759, 5677}, {3759, 5678}, {3760, 5677}, {3760, 5678}, {3760, 5679}, {3760, 5680}, {3761, 5675}, {3761, 5676}, {3761, 5677}, {3761, 5678}, {3761, 5679}, {3761, 5680}, {3762, 5675}, {3762, 5676}, {3762, 5677}, {3762, 5678}, {3762, 5679}, {3762, 5680}, {3763, 5678}, {3763, 5679}, {3763, 5678}, {3763, 5681}, {3763, 5682}, {3763, 5683}, {3764, 5677}, {3764, 5678}, {3764, 5679}, {3764, 5680}, {3764, 5681}, {3764, 5682}, {3764, 5683}, {3765, 5677}, {3765, 5678}, {3765, 5679}, {3766, 5678}};

    public Motherlode(Client client, MotherlodeConfig config) {
        this.client = client;
        this.config = config;
        this.inventory = new MotherlodeInventory(this);
        this.sack = new MotherlodeSack(this, this.inventory, client);
        this.veins = new MotherlodeVeins(this);
        this.rockfalls = new MotherlodeRockfalls(this);
    }

    public MotherlodeInventory getInventory() {
        return this.inventory;
    }

    public MotherlodeSack getSack() {
        return this.sack;
    }

    public MotherlodeVeins getVeins() {
        return this.veins;
    }

    public MotherlodeRockfalls getRockfalls() {
        return this.rockfalls;
    }

    public List<Sector> getSectors(int x, int y, boolean multi) {
        ArrayList<Sector> sectors = new ArrayList<Sector>();
        int[] location = new int[]{x, y};
        if (this.isInSector(this.UPSTAIRS_W, location)) {
            sectors.add(Sector.UPSTAIRS_W);
            if (!multi) {
                return sectors;
            }
        }
        if (this.isInSector(this.UPSTAIRS_NW, location)) {
            sectors.add(Sector.UPSTAIRS_NW);
            if (!multi) {
                return sectors;
            }
        }
        if (this.isInSector(this.UPSTAIRS_SE, location)) {
            sectors.add(Sector.UPSTAIRS_SE);
            if (!multi) {
                return sectors;
            }
        }
        if (this.isInSector(this.UPSTAIRS_S, location)) {
            sectors.add(Sector.UPSTAIRS_S);
            if (!multi) {
                return sectors;
            }
        }
        if (this.isInSector(this.UPSTAIRS_NE, location)) {
            sectors.add(Sector.UPSTAIRS_NE);
            if (!multi) {
                return sectors;
            }
        }
        if (this.isInSector(this.UPSTAIRS_E, location)) {
            sectors.add(Sector.UPSTAIRS_E);
            if (!multi) {
                return sectors;
            }
        }
        if (this.in_region && sectors.isEmpty()) {
            sectors.add(Sector.DOWNSTAIRS);
        }
        return sectors;
    }

    private boolean isInSector(int[][] sector, int[] location) {
        for (int[] point : sector) {
            if (!Arrays.equals(point, location)) continue;
            return true;
        }
        return false;
    }

    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.in_region = this.updateInRegion();
        }
    }

    public void onGameTick() {
        if (!this.in_region || this.client.getLocalPlayer() == null) {
            return;
        }
        int player_x = this.client.getLocalPlayer().getWorldLocation().getX();
        int player_y = this.client.getLocalPlayer().getWorldLocation().getY();
        if (this.player_x == null || this.player_y == null || this.player_x != player_x || this.player_y != player_y) {
            this.player_x = player_x;
            this.player_y = player_y;
            this.player_sector = this.getSectors(player_x, player_y, true);
        }
    }

    public List<Sector> getPlayerSectors() {
        return this.player_sector;
    }

    private boolean updateInRegion() {
        if (this.client == null || this.client.getMapRegions() == null) {
            return false;
        }
        for (int region : this.client.getMapRegions()) {
            if (!this.REGIONS.contains(region)) continue;
            return true;
        }
        return false;
    }

    public boolean inRegion() {
        return this.in_region;
    }

    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tictac7x-motherlode") && event.getKey().equals("maximize_sack_paydirt")) {
            this.updatePayDirtNeeded();
        }
    }

    public void updatePayDirtNeeded() {
        int to_mine;
        int sack_size = this.sack.getSize();
        int sack_pay_dirt = this.sack.countPayDirt();
        int inventory_pay_dirt = this.inventory.countPayDirt();
        int inventory_items = this.inventory.countItems();
        int inventory_size = this.inventory.getSize();
        this.pay_dirt_needed = sack_pay_dirt == sack_size || !this.config.maximizeSackPaydirt() && sack_pay_dirt <= sack_size ? inventory_size - inventory_items : (sack_pay_dirt > sack_size ? inventory_pay_dirt * -1 : ((to_mine = sack_size - sack_pay_dirt) > inventory_size ? inventory_size - inventory_items : Math.min(to_mine - inventory_pay_dirt, inventory_size - inventory_items)));
        if (sack_pay_dirt == sack_size) {
            this.deposits_left = 1;
        } else if (sack_pay_dirt < sack_size) {
            this.deposits_left = (sack_size - sack_pay_dirt) / (inventory_size - inventory_items + inventory_pay_dirt) + 1;
            if (this.config.maximizeSackPaydirt() && this.pay_dirt_needed < inventory_size - inventory_items) {
                ++this.deposits_left;
            }
        } else {
            this.deposits_left = 0;
        }
    }

    public int getDepositsLeft() {
        return this.deposits_left;
    }

    public int getPayDirtNeeded() {
        return this.pay_dirt_needed;
    }

    public boolean needToDepositPayDirt() {
        return this.pay_dirt_needed == 0 && this.inventory.countPayDirt() > 0;
    }

    public boolean isDownStairs() {
        return this.in_region && this.player_sector.contains((Object)Sector.DOWNSTAIRS);
    }

    public boolean isUpstairs() {
        return this.in_region && !this.player_sector.contains((Object)Sector.DOWNSTAIRS);
    }

    public boolean needToMine() {
        return this.in_region && !this.sack.shouldBeEmptied() && this.pay_dirt_needed > 0;
    }
}

