/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.tools;

import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Renderable;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;

public class VisibilityHelper {
    private final Map<Integer, Boolean> visibilityCache = new HashMap<Integer, Boolean>();

    public boolean isObjectVisible(TileObject tileObject) {
        if (!this.visibilityCache.containsKey(tileObject.getId())) {
            this.visibilityCache.put(tileObject.getId(), this.isObjectVisibleChecker(tileObject));
        }
        return this.visibilityCache.get(tileObject.getId());
    }

    public Shape getObjectHull(TileObject tileObject) {
        if (tileObject instanceof GameObject) {
            return ((GameObject)tileObject).getConvexHull();
        }
        if (tileObject instanceof GroundObject) {
            return ((GroundObject)tileObject).getConvexHull();
        }
        if (tileObject instanceof DecorativeObject) {
            return ((DecorativeObject)tileObject).getConvexHull();
        }
        if (tileObject instanceof WallObject) {
            return ((WallObject)tileObject).getConvexHull();
        }
        return null;
    }

    private boolean isObjectVisibleChecker(TileObject tileObject) {
        if (tileObject instanceof GameObject) {
            Model model = this.extractModel(((GameObject)tileObject).getRenderable());
            return this.modelHasVisibleTriangles(model);
        }
        if (tileObject instanceof GroundObject) {
            Model model = this.extractModel(((GroundObject)tileObject).getRenderable());
            return this.modelHasVisibleTriangles(model);
        }
        if (tileObject instanceof DecorativeObject) {
            DecorativeObject decoObj = (DecorativeObject)tileObject;
            Model model1 = this.extractModel(decoObj.getRenderable());
            Model model2 = this.extractModel(decoObj.getRenderable2());
            return this.modelHasVisibleTriangles(model1) || this.modelHasVisibleTriangles(model2);
        }
        if (tileObject instanceof WallObject) {
            WallObject wallObj = (WallObject)tileObject;
            Model model1 = this.extractModel(wallObj.getRenderable1());
            Model model2 = this.extractModel(wallObj.getRenderable2());
            return this.modelHasVisibleTriangles(model1) || this.modelHasVisibleTriangles(model2);
        }
        return false;
    }

    private Model extractModel(Renderable renderable) {
        if (renderable == null) {
            return null;
        }
        return renderable instanceof Model ? (Model)renderable : renderable.getModel();
    }

    private boolean modelHasVisibleTriangles(Model model) {
        if (model == null) {
            return false;
        }
        byte[] triangleTransparencies = model.getFaceTransparencies();
        int triangleCount = model.getFaceCount();
        if (triangleTransparencies == null) {
            return true;
        }
        for (int i = 0; i < triangleCount; ++i) {
            if ((triangleTransparencies[i] & 0xFF) >= 254) continue;
            return true;
        }
        return false;
    }
}

