/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.tools;

import com.questhelper.tools.Icon;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.util.ImageUtil;

public class QuestHelperWorldMapPoint
extends WorldMapPoint {
    private final BufferedImage questWorldImage;
    private final Point questWorldImagePoint;
    private final HashMap<Integer, BufferedImage> arrows = new HashMap();
    private BufferedImage activeQuestArrow;

    public QuestHelperWorldMapPoint(WorldPoint worldPoint, BufferedImage image) {
        super(worldPoint, null);
        BufferedImage iconBackground = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/util/clue_arrow.png");
        this.questWorldImage = new BufferedImage(iconBackground.getWidth(), iconBackground.getHeight(), 2);
        Graphics graphics = this.questWorldImage.getGraphics();
        graphics.drawImage(iconBackground, 0, 0, null);
        int buffer = iconBackground.getWidth() / 2 - image.getWidth() / 2;
        buffer = Math.max(buffer, 0);
        graphics.drawImage(image, buffer, buffer, null);
        this.questWorldImagePoint = new Point(this.questWorldImage.getWidth() / 2, this.questWorldImage.getHeight());
        this.arrows.put(0, Icon.QUEST_STEP_ARROW.getImage());
        this.arrows.put(45, Icon.QUEST_STEP_ARROW_45.getImage());
        this.arrows.put(90, Icon.QUEST_STEP_ARROW_90.getImage());
        this.arrows.put(135, Icon.QUEST_STEP_ARROW_135.getImage());
        this.arrows.put(180, Icon.QUEST_STEP_ARROW_180.getImage());
        this.arrows.put(225, Icon.QUEST_STEP_ARROW_225.getImage());
        this.arrows.put(270, Icon.QUEST_STEP_ARROW_270.getImage());
        this.arrows.put(315, Icon.QUEST_STEP_ARROW_315.getImage());
        this.activeQuestArrow = this.arrows.get(0);
        this.setName("Quest Helper");
        this.setSnapToEdge(true);
        this.setJumpOnClick(true);
        this.setImage(this.questWorldImage);
        this.setImagePoint(this.questWorldImagePoint);
    }

    public void onEdgeSnap() {
        this.setImage(this.activeQuestArrow);
        this.setImagePoint(null);
    }

    public void onEdgeUnsnap() {
        this.setImage(this.questWorldImage);
        this.setImagePoint(this.questWorldImagePoint);
    }

    public void rotateArrow(int rotation) {
        BufferedImage newArrow = this.arrows.get(rotation);
        if (this.activeQuestArrow != newArrow) {
            this.activeQuestArrow = this.arrows.get(rotation);
            if (this.isCurrentlyEdgeSnapped()) {
                this.setImage(this.arrows.get(rotation));
            }
        }
    }
}

