/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.tools;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;

public class QuestPerspective {
    public static Collection<WorldPoint> toLocalInstanceFromReal(Client client, WorldPoint worldPoint) {
        if (!client.isInInstancedRegion()) {
            return Collections.singleton(worldPoint);
        }
        if (worldPoint == null) {
            return Collections.singleton(null);
        }
        ArrayList<WorldPoint> worldPoints = new ArrayList<WorldPoint>();
        int[][][] instanceTemplateChunks = client.getInstanceTemplateChunks();
        for (int z = 0; z < instanceTemplateChunks.length; ++z) {
            for (int x = 0; x < instanceTemplateChunks[z].length; ++x) {
                for (int y = 0; y < instanceTemplateChunks[z][x].length; ++y) {
                    int chunkData = instanceTemplateChunks[z][x][y];
                    int rotation = chunkData >> 1 & 3;
                    int templateChunkY = (chunkData >> 3 & 0x7FF) * 8;
                    int templateChunkX = (chunkData >> 14 & 0x3FF) * 8;
                    if (worldPoint.getX() < templateChunkX || worldPoint.getX() >= templateChunkX + 8 || worldPoint.getY() < templateChunkY || worldPoint.getY() >= templateChunkY + 8) continue;
                    WorldPoint p = new WorldPoint(client.getBaseX() + x * 8 + (worldPoint.getX() & 7), client.getBaseY() + y * 8 + (worldPoint.getY() & 7), z);
                    if (!(p = QuestPerspective.rotate(p, rotation)).isInScene(client)) continue;
                    worldPoints.add(p);
                }
            }
        }
        return worldPoints;
    }

    private static WorldPoint rotate(WorldPoint point, int rotation) {
        int chunkX = point.getX() & 0xFFFFFFF8;
        int chunkY = point.getY() & 0xFFFFFFF8;
        int x = point.getX() & 7;
        int y = point.getY() & 7;
        switch (rotation) {
            case 1: {
                return new WorldPoint(chunkX + y, chunkY + (7 - x), point.getPlane());
            }
            case 2: {
                return new WorldPoint(chunkX + (7 - x), chunkY + (7 - y), point.getPlane());
            }
            case 3: {
                return new WorldPoint(chunkX + (7 - y), chunkY + x, point.getPlane());
            }
        }
        return point;
    }

    public static LocalPoint getInstanceLocalPointFromReal(Client client, WorldPoint wp) {
        WorldPoint instanceWorldPoint = QuestPerspective.getInstanceWorldPointFromReal(client, wp);
        if (instanceWorldPoint == null) {
            return null;
        }
        return LocalPoint.fromWorld((Client)client, (WorldPoint)instanceWorldPoint);
    }

    public static WorldPoint getInstanceWorldPointFromReal(Client client, WorldPoint wp) {
        Collection<WorldPoint> points = QuestPerspective.toLocalInstanceFromReal(client, wp);
        for (WorldPoint point : points) {
            if (point == null) continue;
            return point;
        }
        return null;
    }

    public static WorldPoint getRealWorldPointFromLocal(Client client, WorldPoint wp) {
        LocalPoint lp = LocalPoint.fromWorld((Client)client, (WorldPoint)wp);
        if (lp == null) {
            return null;
        }
        return WorldPoint.fromLocalInstance((Client)client, (LocalPoint)lp);
    }

    public static Rectangle getWorldMapClipArea(Client client) {
        Widget widget = client.getWidget(38993927);
        if (widget == null) {
            return null;
        }
        return widget.getBounds();
    }

    public static Point mapWorldPointToGraphicsPoint(Client client, WorldPoint worldPoint) {
        RenderOverview ro = client.getRenderOverview();
        if (worldPoint == null) {
            return null;
        }
        if (!ro.getWorldMapData().surfaceContainsPosition(worldPoint.getX(), worldPoint.getY())) {
            return null;
        }
        float pixelsPerTile = ro.getWorldMapZoom();
        Widget map = client.getWidget(38993927);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
            Point worldMapPosition = ro.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile);
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile);
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    public static Point getMinimapPoint(Client client, WorldPoint start, WorldPoint destination) {
        RenderOverview ro = client.getRenderOverview();
        if (ro.getWorldMapData().surfaceContainsPosition(start.getX(), start.getY()) != ro.getWorldMapData().surfaceContainsPosition(destination.getX(), destination.getY())) {
            return null;
        }
        int x = destination.getX() - start.getX();
        int y = destination.getY() - start.getY();
        float maxDistance = Math.max(Math.abs(x), Math.abs(y));
        x *= 100;
        y *= 100;
        x = (int)((float)x / maxDistance);
        y = (int)((float)y / maxDistance);
        Widget minimapDrawWidget = client.isResized() ? (client.getVarbitValue(4607) == 1 ? client.getWidget(10747933) : client.getWidget(10551325)) : client.getWidget(35913749);
        if (minimapDrawWidget == null) {
            return null;
        }
        int angle = client.getMapAngle() & 0x7FF;
        int sin = Perspective.SINE[angle];
        int cos = Perspective.COSINE[angle];
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int miniMapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int miniMapY = minimapDrawWidget.getHeight() / 2 + loc.getY() + yy;
        return new Point(miniMapX, miniMapY);
    }
}

