/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.playermadesteps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ExtendedRuneliteObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.overlay.DirectionArrow;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.OverlayUtil;

public class RuneliteObjectStep
extends DetailedQuestStep {
    @Inject
    private RuneliteObjectManager runeliteObjectManager;
    private final ExtendedRuneliteObject extendedRuneliteObject;
    List<String> npcsGroupsToDelete = new ArrayList<String>();
    HashMap<String, ExtendedRuneliteObject> npcsToDelete = new HashMap();

    public RuneliteObjectStep(QuestHelper questHelper, ExtendedRuneliteObject extendedRuneliteObject, String text, Requirement ... requirements) {
        super(questHelper, extendedRuneliteObject.getWorldPoint(), text, requirements);
        this.extendedRuneliteObject = extendedRuneliteObject;
    }

    @Override
    public void startUp() {
        super.startUp();
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.clientThread.invokeLater(this::removeRuneliteNpcs);
    }

    private void removeRuneliteNpcs() {
        this.runeliteObjectManager.removeGroupAndSubgroups(this.toString());
    }

    @Override
    public void renderArrow(Graphics2D graphics) {
        if (!this.extendedRuneliteObject.getWorldPoint().isInScene(this.client)) {
            return;
        }
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            Point p;
            if (!this.extendedRuneliteObject.isRuneliteObjectActive()) {
                super.renderArrow(graphics);
            } else if (!this.hideWorldArrow && (p = Perspective.localToCanvas((Client)this.client, (LocalPoint)this.extendedRuneliteObject.getRuneliteObject().getLocation(), (int)this.client.getPlane(), (int)this.extendedRuneliteObject.getRuneliteObject().getModelHeight())) != null) {
                DirectionArrow.drawWorldArrow(graphics, this.getQuestHelper().getConfig().targetOverlayColor(), p.getX(), p.getY() - this.ARROW_SHIFT_Y);
            }
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWorldOverlayHint(graphics, plugin);
        Color configColor = this.getQuestHelper().getConfig().targetOverlayColor();
        this.highlightNpc(configColor, graphics);
    }

    private void highlightNpc(Color color, Graphics2D graphics) {
        if (!this.extendedRuneliteObject.getWorldPoint().isInScene(this.client)) {
            return;
        }
        switch (this.questHelper.getConfig().highlightStyleNpcs()) {
            case CONVEX_HULL: 
            case OUTLINE: {
                if (!this.extendedRuneliteObject.getRuneliteObject().isActive()) break;
                this.modelOutlineRenderer.drawOutline(this.extendedRuneliteObject.getRuneliteObject(), this.questHelper.getConfig().outlineThickness(), color, this.questHelper.getConfig().outlineFeathering());
                break;
            }
            case TILE: {
                Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)this.extendedRuneliteObject.getRuneliteObject().getLocation());
                if (poly == null) break;
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
                break;
            }
        }
    }
}

