/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.overlay;

import com.questhelper.steps.overlay.DirectionArrow;
import com.questhelper.steps.tools.QuestPerspective;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.List;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.OverlayUtil;

public class WorldLines {
    public static void createWorldMapLines(Graphics2D graphics, Client client, List<WorldPoint> linePoints, Color color) {
        Rectangle mapViewArea = QuestPerspective.getWorldMapClipArea(client);
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            Point startPoint = QuestPerspective.mapWorldPointToGraphicsPoint(client, linePoints.get(i));
            Point endPoint = QuestPerspective.mapWorldPointToGraphicsPoint(client, linePoints.get(i + 1));
            WorldLines.renderWorldMapLine(graphics, client, mapViewArea, startPoint, endPoint, color);
        }
    }

    public static void createMinimapLines(Graphics2D graphics, Client client, List<WorldPoint> linePoints, Color color) {
        if (linePoints == null || linePoints.size() < 2) {
            return;
        }
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            WorldPoint dontRenderPoint = new WorldPoint(0, 0, 0);
            WorldPoint currentPoint = linePoints.get(i);
            WorldPoint nextPoint = linePoints.get(i + 1);
            if (currentPoint == null || currentPoint.equals((Object)dontRenderPoint) || nextPoint == null || nextPoint.equals((Object)dontRenderPoint)) continue;
            LocalPoint startPoint = QuestPerspective.getInstanceLocalPointFromReal(client, currentPoint);
            LocalPoint destinationPoint = QuestPerspective.getInstanceLocalPointFromReal(client, nextPoint);
            if (startPoint == null || destinationPoint == null) continue;
            Point startPosOnMinimap = Perspective.localToMinimap((Client)client, (LocalPoint)startPoint, (int)10000000);
            Point destinationPosOnMinimap = Perspective.localToMinimap((Client)client, (LocalPoint)destinationPoint, (int)10000000);
            if (destinationPosOnMinimap == null || startPosOnMinimap == null) continue;
            Line2D.Double line = new Line2D.Double(startPosOnMinimap.getX(), startPosOnMinimap.getY(), destinationPosOnMinimap.getX(), destinationPosOnMinimap.getY());
            Rectangle bounds = new Rectangle(0, 0, client.getCanvasWidth(), client.getCanvasHeight());
            Widget minimapWidget = client.getWidget(10551325);
            if (minimapWidget == null) {
                minimapWidget = client.getWidget(10747933);
            }
            if (minimapWidget == null) {
                minimapWidget = client.getWidget(35913749);
            }
            if (minimapWidget != null) {
                bounds = minimapWidget.getBounds();
            }
            DirectionArrow.drawLine(graphics, line, color, bounds);
        }
    }

    public static void renderWorldMapLine(Graphics2D graphics, Client client, Rectangle mapViewArea, Point startPoint, Point endPoint, Color color) {
        if (mapViewArea == null || startPoint == null || endPoint == null) {
            return;
        }
        if (!mapViewArea.contains(startPoint.getX(), startPoint.getY()) && !mapViewArea.contains(endPoint.getX(), endPoint.getY())) {
            return;
        }
        Line2D.Double line = new Line2D.Double(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
        DirectionArrow.drawLine(graphics, line, color, QuestPerspective.getWorldMapClipArea(client));
    }

    public static Line2D.Double getWorldLines(@Nonnull Client client, @Nonnull LocalPoint startLocation, LocalPoint endLocation) {
        int plane = client.getPlane();
        int startX = startLocation.getX();
        int startY = startLocation.getY();
        int endX = endLocation.getX();
        int endY = endLocation.getY();
        int sceneX = startLocation.getSceneX();
        int sceneY = startLocation.getSceneY();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return null;
        }
        int startHeight = Perspective.getTileHeight((Client)client, (LocalPoint)startLocation, (int)plane);
        int endHeight = Perspective.getTileHeight((Client)client, (LocalPoint)endLocation, (int)plane);
        Point p1 = Perspective.localToCanvas((Client)client, (int)startX, (int)startY, (int)startHeight);
        Point p2 = Perspective.localToCanvas((Client)client, (int)endX, (int)endY, (int)endHeight);
        if (p1 == null || p2 == null) {
            return null;
        }
        return new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static void drawLinesOnWorld(Graphics2D graphics, Client client, List<WorldPoint> linePoints, Color color) {
        for (int i = 0; i < linePoints.size() - 1; ++i) {
            Line2D.Double newLine;
            int changeToGetYToBorder;
            int goalLine;
            int changeToGetXToBorder;
            int goalLine2;
            int yDiff;
            int xDiff;
            WorldPoint startWp = linePoints.get(i);
            WorldPoint endWp = linePoints.get(i + 1);
            if (startWp == null || endWp == null || startWp.equals((Object)new WorldPoint(0, 0, 0)) || endWp.equals((Object)new WorldPoint(0, 0, 0)) || startWp.getPlane() != endWp.getPlane()) continue;
            LocalPoint startLp = QuestPerspective.getInstanceLocalPointFromReal(client, startWp);
            LocalPoint endLp = QuestPerspective.getInstanceLocalPointFromReal(client, endWp);
            if (startLp == null && endLp == null) continue;
            int MAX_LP = 13056;
            if (endLp == null) {
                xDiff = endWp.getX() - startWp.getX();
                yDiff = endWp.getY() - startWp.getY();
                if (xDiff != 0) {
                    goalLine2 = 0;
                    if (xDiff > 0) {
                        goalLine2 = MAX_LP;
                    }
                    changeToGetXToBorder = (goalLine2 - startLp.getX()) / xDiff;
                } else {
                    changeToGetXToBorder = Integer.MAX_VALUE;
                }
                if (yDiff != 0) {
                    goalLine = 0;
                    if (yDiff > 0) {
                        goalLine = MAX_LP;
                    }
                    changeToGetYToBorder = (goalLine - startLp.getY()) / yDiff;
                } else {
                    changeToGetYToBorder = Integer.MAX_VALUE;
                }
                endLp = Math.abs(changeToGetXToBorder) < Math.abs(changeToGetYToBorder) ? new LocalPoint(startLp.getX() + xDiff * changeToGetXToBorder, startLp.getY() + yDiff * changeToGetXToBorder) : new LocalPoint(startLp.getX() + xDiff * changeToGetYToBorder, startLp.getY() + yDiff * changeToGetYToBorder);
            }
            if (startLp == null) {
                xDiff = startWp.getX() - endWp.getX();
                yDiff = startWp.getY() - endWp.getY();
                if (xDiff != 0) {
                    goalLine2 = 0;
                    if (xDiff > 0) {
                        goalLine2 = MAX_LP;
                    }
                    changeToGetXToBorder = (goalLine2 - endLp.getX()) / xDiff;
                } else {
                    changeToGetXToBorder = 1000000000;
                }
                if (yDiff != 0) {
                    goalLine = 0;
                    if (yDiff > 0) {
                        goalLine = MAX_LP;
                    }
                    changeToGetYToBorder = (goalLine - endLp.getY()) / yDiff;
                } else {
                    changeToGetYToBorder = 1000000000;
                }
                startLp = Math.abs(changeToGetXToBorder) < Math.abs(changeToGetYToBorder) ? new LocalPoint(endLp.getX() + xDiff * changeToGetXToBorder, endLp.getY() + yDiff * changeToGetXToBorder) : new LocalPoint(endLp.getX() + xDiff * changeToGetYToBorder, endLp.getY() + yDiff * changeToGetYToBorder);
            }
            if ((newLine = WorldLines.getWorldLines(client, startLp, endLp)) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)newLine, (Color)color);
        }
    }
}

