/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.overlay;

import com.questhelper.steps.tools.QuestPerspective;
import com.questhelper.tools.QuestHelperWorldMapPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class DirectionArrow {
    public static void renderMinimapArrow(Graphics2D graphics, Client client, WorldPoint worldPoint, Color color) {
        int MAX_DRAW_DISTANCE = 16;
        Player player = client.getLocalPlayer();
        if (player == null) {
            return;
        }
        WorldPoint playerRealLocation = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)player.getLocalLocation());
        if (playerRealLocation == null) {
            return;
        }
        if (worldPoint == null) {
            return;
        }
        if (worldPoint.distanceTo(playerRealLocation) >= 16) {
            DirectionArrow.createMinimapDirectionArrow(graphics, client, playerRealLocation, worldPoint, color);
            return;
        }
        WorldPoint fakeDestinationWp = QuestPerspective.getInstanceWorldPointFromReal(client, worldPoint);
        if (fakeDestinationWp == null) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)client, (WorldPoint)fakeDestinationWp);
        if (lp == null) {
            return;
        }
        Point posOnMinimap = Perspective.localToMinimap((Client)client, (LocalPoint)lp);
        if (posOnMinimap == null) {
            return;
        }
        Line2D.Double line = new Line2D.Double(posOnMinimap.getX(), posOnMinimap.getY() - 18, posOnMinimap.getX(), posOnMinimap.getY() - 8);
        DirectionArrow.drawMinimapArrow(graphics, line, color);
    }

    protected static void createMinimapDirectionArrow(Graphics2D graphics, Client client, WorldPoint playerRealWp, WorldPoint wp, Color color) {
        Player player = client.getLocalPlayer();
        if (player == null) {
            return;
        }
        if (wp == null) {
            return;
        }
        Point playerPosOnMinimap = player.getMinimapLocation();
        Point destinationPosOnMinimap = QuestPerspective.getMinimapPoint(client, playerRealWp, wp);
        if (playerPosOnMinimap == null || destinationPosOnMinimap == null) {
            return;
        }
        double xDiff = playerPosOnMinimap.getX() - destinationPosOnMinimap.getX();
        double yDiff = destinationPosOnMinimap.getY() - playerPosOnMinimap.getY();
        double angle = Math.atan2(yDiff, xDiff);
        int startX = (int)((double)playerPosOnMinimap.getX() - Math.cos(angle) * 55.0);
        int startY = (int)((double)playerPosOnMinimap.getY() + Math.sin(angle) * 55.0);
        int endX = (int)((double)playerPosOnMinimap.getX() - Math.cos(angle) * 65.0);
        int endY = (int)((double)playerPosOnMinimap.getY() + Math.sin(angle) * 65.0);
        Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
        DirectionArrow.drawMinimapArrow(graphics, line, color);
    }

    public static void drawWorldArrow(Graphics2D graphics, Color color, int startX, int startY) {
        Line2D.Double line = new Line2D.Double(startX, startY - 13, startX, startY);
        int headWidth = 5;
        int headHeight = 4;
        int lineWidth = 9;
        DirectionArrow.drawArrow(graphics, line, color, lineWidth, headHeight, headWidth);
    }

    public static void drawMinimapArrow(Graphics2D graphics, Line2D.Double line, Color color) {
        DirectionArrow.drawArrow(graphics, line, color, 6, 2, 2);
    }

    public static void drawArrow(Graphics2D graphics, Line2D.Double line, Color color, int width, int tipHeight, int tipWidth) {
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(width));
        graphics.draw(line);
        DirectionArrow.drawWorldArrowHead(graphics, line, tipHeight, tipWidth);
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(width - 3));
        graphics.draw(line);
        DirectionArrow.drawWorldArrowHead(graphics, line, tipHeight - 2, tipWidth - 2);
        graphics.setStroke(new BasicStroke(1.0f));
    }

    public static void drawWorldArrowHead(Graphics2D g2d, Line2D.Double line, int extraSizeHeight, int extraSizeWidth) {
        AffineTransform tx = new AffineTransform();
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 6 + extraSizeHeight);
        arrowHead.addPoint(-6 - extraSizeWidth, -1 - extraSizeHeight);
        arrowHead.addPoint(6 + extraSizeWidth, -1 - extraSizeHeight);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(line.x2, line.y2);
        tx.rotate(angle - 1.5707963267948966);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setTransform(tx);
        g.fill(arrowHead);
        g.dispose();
    }

    public static void drawLineArrowHead(Graphics2D g2d, Line2D.Double line) {
        AffineTransform tx = new AffineTransform();
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 0);
        arrowHead.addPoint(-3, -6);
        arrowHead.addPoint(3, -6);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(line.x2, line.y2);
        tx.rotate(angle - 1.5707963267948966);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setTransform(tx);
        g.fill(arrowHead);
        g.dispose();
    }

    public static void drawLine(Graphics2D graphics, Line2D.Double line, Color color, Rectangle clippingRegion) {
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.setClip(clippingRegion);
        graphics.setColor(color);
        graphics.draw(line);
        DirectionArrow.drawLineArrowHead(graphics, line);
    }

    public static void renderWorldMapArrow(Rectangle mapViewArea, Point drawPoint, QuestHelperWorldMapPoint mapPoint) {
        if (mapViewArea != null && drawPoint != null && !mapViewArea.contains(drawPoint.getX(), drawPoint.getY())) {
            if ((double)drawPoint.getX() < mapViewArea.getMinX()) {
                if ((double)drawPoint.getY() < mapViewArea.getMinY()) {
                    mapPoint.rotateArrow(225);
                } else if ((double)drawPoint.getY() > mapViewArea.getMaxY()) {
                    mapPoint.rotateArrow(135);
                } else {
                    mapPoint.rotateArrow(180);
                }
            } else if ((double)drawPoint.getX() > mapViewArea.getMaxX()) {
                if ((double)drawPoint.getY() < mapViewArea.getMinY()) {
                    mapPoint.rotateArrow(315);
                } else if ((double)drawPoint.getY() > mapViewArea.getMaxY()) {
                    mapPoint.rotateArrow(45);
                } else {
                    mapPoint.rotateArrow(0);
                }
            } else if ((double)drawPoint.getY() < mapViewArea.getMinY()) {
                mapPoint.rotateArrow(270);
            } else if ((double)drawPoint.getY() > mapViewArea.getMaxY()) {
                mapPoint.rotateArrow(90);
            }
        }
    }
}

