/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.choice;

import com.questhelper.QuestHelperConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public class WidgetChoiceStep {
    protected final QuestHelperConfig config;
    private final String choice;
    String expectedTextInWidget;
    private Pattern pattern;
    protected List<String> excludedStrings;
    protected int excludedGroupId;
    protected int excludedChildId;
    private final int choiceById;
    protected final int groupId;
    protected final int childId;
    protected boolean shouldNumber = false;
    private int groupIdForChecking;

    public WidgetChoiceStep(QuestHelperConfig config, String choice, int groupId, int childId) {
        this.config = config;
        this.choice = choice;
        this.choiceById = -1;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
        this.pattern = null;
    }

    public WidgetChoiceStep(QuestHelperConfig config, int groupId, int childId) {
        this.config = config;
        this.choice = null;
        this.choiceById = -1;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
        this.pattern = null;
    }

    public WidgetChoiceStep(QuestHelperConfig config, Pattern pattern, int groupId, int childId) {
        this.config = config;
        this.choice = null;
        this.choiceById = -1;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
        this.pattern = pattern;
    }

    public WidgetChoiceStep(QuestHelperConfig config, int choiceId, int groupId, int childId) {
        this.config = config;
        this.choice = null;
        this.choiceById = choiceId;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
    }

    public WidgetChoiceStep(QuestHelperConfig config, int choiceId, String choice, int groupId, int childId) {
        this.config = config;
        this.choice = choice;
        this.choiceById = choiceId;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
    }

    public WidgetChoiceStep(QuestHelperConfig config, int choiceId, Pattern pattern, int groupId, int childId) {
        this.config = config;
        this.choice = null;
        this.choiceById = choiceId;
        this.groupId = groupId;
        this.groupIdForChecking = groupId;
        this.childId = childId;
        this.pattern = pattern;
    }

    public void addExclusion(int excludedGroupId, int excludedChildId, String excludedString) {
        this.excludedStrings = Collections.singletonList(excludedString);
        this.excludedGroupId = excludedGroupId;
        this.excludedChildId = excludedChildId;
    }

    public void addExclusions(int excludedGroupId, int excludedChildId, String ... excludedStrings) {
        this.excludedStrings = Arrays.asList(excludedStrings);
        this.excludedGroupId = excludedGroupId;
        this.excludedChildId = excludedChildId;
    }

    public void highlightChoice(Client client) {
        Widget dialogChoice;
        Widget[] exclusionChoices;
        Widget exclusionDialogChoice = client.getWidget(this.excludedGroupId, this.excludedChildId);
        if (exclusionDialogChoice != null && (exclusionChoices = exclusionDialogChoice.getChildren()) != null) {
            for (Widget currentExclusionChoice : exclusionChoices) {
                for (String excludedString : this.excludedStrings) {
                    if (!currentExclusionChoice.getText().contains(excludedString)) continue;
                    return;
                }
            }
        }
        if ((dialogChoice = client.getWidget(this.groupId, this.childId)) == null) {
            return;
        }
        Widget[] choices = dialogChoice.getChildren();
        this.checkWidgets(choices);
        Widget[] nestedChildren = dialogChoice.getNestedChildren();
        this.checkWidgets(nestedChildren);
    }

    protected void checkWidgets(Widget[] choices) {
        if (choices != null && choices.length > 0) {
            if (this.choiceById != -1 && choices[this.choiceById] != null) {
                if (this.choice != null && this.choice.equals(choices[this.choiceById].getText()) || this.pattern != null && this.pattern.matcher(choices[this.choiceById].getText()).find() || this.choice == null && this.pattern == null) {
                    this.highlightText(choices[this.choiceById], this.choiceById);
                }
            } else {
                for (int i = 0; i < choices.length; ++i) {
                    if (!choices[i].getText().equals(this.choice) && (this.pattern == null || !this.pattern.matcher(choices[i].getText()).find())) continue;
                    this.highlightText(choices[i], i);
                    return;
                }
            }
        }
    }

    protected void highlightText(Widget text, int option) {
        if (!this.config.showTextHighlight()) {
            return;
        }
        if (this.shouldNumber) {
            text.setText("[" + option + "] " + text.getText());
        }
        text.setTextColor(this.config.textHighlightColor().getRGB());
        text.setOnMouseLeaveListener(new Object[]{ev -> text.setTextColor(this.config.textHighlightColor().getRGB())});
    }

    public String getChoice() {
        return this.choice;
    }

    public void setExpectedTextInWidget(String expectedTextInWidget) {
        this.expectedTextInWidget = expectedTextInWidget;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupIdForChecking(int groupIdForChecking) {
        this.groupIdForChecking = groupIdForChecking;
    }

    public int getGroupIdForChecking() {
        return this.groupIdForChecking;
    }
}

