/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps.choice;

import com.questhelper.steps.choice.DialogChoiceStep;
import java.util.ArrayList;
import java.util.Collections;
import net.runelite.api.Client;

public class DialogChoiceSteps {
    private final ArrayList<DialogChoiceStep> choices = new ArrayList();

    public DialogChoiceSteps(DialogChoiceStep ... choices) {
        Collections.addAll(this.choices, choices);
    }

    public void addChoice(DialogChoiceStep choice) {
        this.choices.add(choice);
    }

    public void addDialogChoiceWithExclusion(DialogChoiceStep choice, String exclusionString) {
        choice.addExclusion(219, 1, exclusionString);
        this.addChoice(choice);
    }

    public void addDialogChoiceWithExclusions(DialogChoiceStep choice, String ... exclusionStrings) {
        choice.addExclusions(219, 1, exclusionStrings);
        this.addChoice(choice);
    }

    public void checkChoices(Client client, String lastDialog) {
        if (this.choices.isEmpty()) {
            return;
        }
        for (DialogChoiceStep currentChoice : this.choices) {
            if (currentChoice.getExpectedPreviousLine() != null && !lastDialog.contains(currentChoice.getExpectedPreviousLine())) continue;
            currentChoice.highlightChoice(client);
        }
    }

    public void resetChoices() {
        this.choices.clear();
    }

    public ArrayList<DialogChoiceStep> getChoices() {
        return this.choices;
    }
}

