/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.WidgetDetails;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.widgets.Widget;

public class WidgetStep
extends DetailedQuestStep {
    protected List<WidgetDetails> widgetDetails = new ArrayList<WidgetDetails>();

    public WidgetStep(QuestHelper questHelper, String text, int groupID, int childID) {
        super(questHelper, text, new Requirement[0]);
        this.widgetDetails.add(new WidgetDetails(groupID, childID, -1));
    }

    public WidgetStep(QuestHelper questHelper, String text, WidgetDetails ... widgetDetails) {
        super(questHelper, text, new Requirement[0]);
        this.widgetDetails.addAll(Arrays.asList(widgetDetails));
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        for (WidgetDetails widgetDetail : this.widgetDetails) {
            Widget tmpWidget;
            Widget widget = this.client.getWidget(widgetDetail.groupID, widgetDetail.childID);
            if (widget == null || widget.isHidden()) continue;
            if (widgetDetail.childChildID != -1 && (tmpWidget = widget.getChild(widgetDetail.childChildID)) != null) {
                widget = tmpWidget;
            }
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
        }
    }

    public void setWidgetDetails(List<WidgetDetails> widgetDetails) {
        this.widgetDetails = widgetDetails;
    }
}

