/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public class WidgetHighlights {
    protected final int groupId;
    protected final int childId;
    protected Integer itemIdRequirement;
    protected final boolean checkChildren;

    public WidgetHighlights(int groupId, int childId) {
        this.groupId = groupId;
        this.childId = childId;
        this.checkChildren = false;
    }

    public WidgetHighlights(int groupId, int childId, int itemIdRequirement) {
        this(groupId, childId, itemIdRequirement, false);
    }

    public WidgetHighlights(int groupId, int childId, int itemIdRequirement, boolean checkChildren) {
        this.groupId = groupId;
        this.childId = childId;
        this.itemIdRequirement = itemIdRequirement;
        this.checkChildren = checkChildren;
    }

    public void highlightChoices(Graphics2D graphics, Client client, QuestHelperPlugin questHelper) {
        Widget widgetToHighlight = client.getWidget(this.groupId, this.childId);
        if (widgetToHighlight == null) {
            return;
        }
        if (widgetToHighlight.isHidden()) {
            return;
        }
        this.highlightChoices(widgetToHighlight, graphics, questHelper);
    }

    public void highlightChoices(Widget parentWidget, Graphics2D graphics, QuestHelperPlugin questHelper) {
        if (parentWidget == null) {
            return;
        }
        Widget[] widgets = parentWidget.getChildren();
        Widget[] wow = parentWidget.getStaticChildren();
        if (this.checkChildren && widgets != null) {
            for (Widget widget : widgets) {
                this.highlightChoices(widget, graphics, questHelper);
            }
            for (Widget widget : wow) {
                this.highlightChoices(widget, graphics, questHelper);
            }
        }
        this.highlightChoice(graphics, questHelper, parentWidget);
    }

    private void highlightChoice(Graphics2D graphics, QuestHelperPlugin questHelper, Widget widgetToHighlight) {
        if (widgetToHighlight == null || this.itemIdRequirement != null && widgetToHighlight.getItemId() != this.itemIdRequirement.intValue()) {
            return;
        }
        graphics.setColor(new Color(questHelper.getConfig().targetOverlayColor().getRed(), questHelper.getConfig().targetOverlayColor().getGreen(), questHelper.getConfig().targetOverlayColor().getBlue(), 65));
        graphics.fill(widgetToHighlight.getBounds());
        graphics.setColor(questHelper.getConfig().targetOverlayColor());
        graphics.draw(widgetToHighlight.getBounds());
    }

    public int getGroupId() {
        return this.groupId;
    }

    public Integer getItemIdRequirement() {
        return this.itemIdRequirement;
    }
}

