/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.steps.QuestStep;
import com.questhelper.tools.QuestWidgets;
import java.awt.Color;
import java.awt.Graphics2D;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.ColorUtil;

public class QuestSyncStep
extends QuestStep {
    private boolean hasScrolled;
    private final QuestHelperQuest quest;

    public QuestSyncStep(QuestHelper questHelper, QuestHelperQuest quest, String text) {
        super(questHelper, text);
        this.quest = quest;
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget questContainer = this.client.getWidget(QuestWidgets.QUESTLIST_CONTAINER.getPackedId());
        if (questContainer == null || questContainer.isHidden()) {
            return;
        }
        Widget questsContainer = this.client.getWidget(QuestWidgets.QUEST_CONTAINER.getPackedId());
        Widget finalEmoteWidget = null;
        Color overlayColor = this.questHelper.getConfig().targetOverlayColor();
        for (Widget questWidget : questsContainer.getDynamicChildren()) {
            if (!questWidget.getText().equals(this.quest.getName())) continue;
            finalEmoteWidget = questWidget;
            if (questWidget.getCanvasLocation().getY() <= questContainer.getCanvasLocation().getY() || questWidget.getCanvasLocation().getY() >= questContainer.getCanvasLocation().getY() + questContainer.getHeight()) continue;
            graphics.setColor(ColorUtil.colorWithAlpha((Color)overlayColor, (int)65));
            graphics.fill(questWidget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(questWidget.getBounds());
            break;
        }
        if (!this.hasScrolled) {
            this.hasScrolled = true;
            this.scrollToWidget(finalEmoteWidget);
        }
    }

    void scrollToWidget(Widget widget) {
        Widget parent = this.client.getWidget(QuestWidgets.QUESTLIST_CONTAINER.getPackedId());
        if (widget == null || parent == null) {
            return;
        }
        int newScroll = Math.max(0, Math.min(parent.getScrollHeight(), widget.getRelativeY() / 2 + widget.getHeight() / 2 - parent.getHeight() / 2));
        this.client.runScript(new Object[]{72, QuestWidgets.QUESTLIST_SCROLLBAR.getId(), QuestWidgets.QUESTLIST_CONTAINER.getId(), newScroll});
    }
}

