/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.overlays.QuestHelperOverlay;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.WidgetHighlights;
import com.questhelper.steps.choice.DialogChoiceChange;
import com.questhelper.steps.choice.DialogChoiceStep;
import com.questhelper.steps.choice.DialogChoiceSteps;
import com.questhelper.steps.choice.WidgetChoiceStep;
import com.questhelper.steps.choice.WidgetChoiceSteps;
import com.questhelper.steps.choice.WidgetTextChange;
import com.questhelper.steps.overlay.IconOverlay;
import com.questhelper.tools.VisibilityHelper;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public abstract class QuestStep
implements Module {
    @Inject
    protected Client client;
    @Inject
    protected ClientThread clientThread;
    @Inject
    ItemManager itemManager;
    @Inject
    protected SpriteManager spriteManager;
    @Inject
    protected ModelOutlineRenderer modelOutlineRenderer;
    @Inject
    VisibilityHelper visibilityHelper;
    protected List<String> text;
    protected List<String> overlayText = new ArrayList<String>();
    protected int ARROW_SHIFT_Y = 15;
    private boolean locked;
    private boolean isLockable;
    private boolean blocker;
    private boolean unlockable = true;
    private Requirement lockingCondition;
    private int currentCutsceneStatus = 0;
    protected boolean inCutscene;
    protected boolean allowInCutscene = false;
    protected int iconItemID = -1;
    protected BufferedImage icon;
    protected final QuestHelper questHelper;
    protected DialogChoiceSteps choices = new DialogChoiceSteps(new DialogChoiceStep[0]);
    protected WidgetChoiceSteps widgetChoices = new WidgetChoiceSteps(new WidgetChoiceStep[0]);
    protected List<WidgetHighlights> widgetsToHighlight = new ArrayList<WidgetHighlights>();
    private final List<QuestStep> substeps = new ArrayList<QuestStep>();
    private Requirement conditionToHide;
    private boolean showInSidebar = true;
    protected String lastDialogSeen = "";

    public QuestStep(QuestHelper questHelper) {
        this.questHelper = questHelper;
    }

    public QuestStep(QuestHelper questHelper, String text) {
        this.text = new ArrayList<String>(Collections.singletonList(text));
        this.questHelper = questHelper;
    }

    public QuestStep(QuestHelper questHelper, List<String> text) {
        this.text = text;
        this.questHelper = questHelper;
    }

    public void setOverlayText(String text) {
        this.overlayText.add(text);
    }

    public void setOverlayText(String ... text) {
        this.overlayText.addAll(Arrays.asList(text));
    }

    public void configure(Binder binder) {
    }

    public void startUp() {
        this.clientThread.invokeLater(this::highlightChoice);
        this.clientThread.invokeLater(this::highlightWidgetChoice);
        this.setupIcon();
    }

    public void shutDown() {
    }

    public void addSubSteps(QuestStep ... substep) {
        this.substeps.addAll(Arrays.asList(substep));
    }

    public void addSubSteps(Collection<QuestStep> substeps) {
        this.substeps.addAll(substeps);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.allowInCutscene) {
            int newCutsceneStatus = this.client.getVarbitValue(QuestVarbits.CUTSCENE.getId());
            if (this.currentCutsceneStatus == 0 && newCutsceneStatus == 1) {
                this.enteredCutscene();
            } else if (this.currentCutsceneStatus == 1 && newCutsceneStatus == 0) {
                this.leftCutscene();
            }
            this.currentCutsceneStatus = newCutsceneStatus;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 219) {
            this.clientThread.invokeLater(this::highlightChoice);
        }
        for (WidgetChoiceStep choice : this.widgetChoices.getChoices()) {
            if (event.getGroupId() != choice.getGroupIdForChecking()) continue;
            this.clientThread.invokeLater(this::highlightWidgetChoice);
        }
    }

    public void addText(String newLine) {
        if (this.text == null) {
            this.text = new ArrayList<String>();
        }
        this.text.add(newLine);
    }

    public void enteredCutscene() {
        this.inCutscene = true;
    }

    public void leftCutscene() {
        this.inCutscene = false;
    }

    public void highlightChoice() {
        this.choices.checkChoices(this.client, this.lastDialogSeen);
    }

    public void setText(String text) {
        this.text = QuestUtil.toArrayList(text);
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public void highlightWidgetChoice() {
        this.widgetChoices.checkChoices(this.client);
    }

    public void addDialogStep(String choice) {
        this.choices.addChoice(new DialogChoiceStep(this.questHelper.getConfig(), choice));
    }

    public void addDialogStep(Pattern pattern) {
        this.choices.addChoice(new DialogChoiceStep(this.questHelper.getConfig(), pattern));
    }

    public void resetDialogSteps() {
        this.choices.resetChoices();
    }

    public void addDialogStepWithExclusion(String choice, String exclusionString) {
        this.choices.addDialogChoiceWithExclusion(new DialogChoiceStep(this.questHelper.getConfig(), choice), exclusionString);
    }

    public void addDialogStepWithExclusions(String choice, String ... exclusionString) {
        this.choices.addDialogChoiceWithExclusions(new DialogChoiceStep(this.questHelper.getConfig(), choice), exclusionString);
    }

    public void addDialogStep(int id, String choice) {
        this.choices.addChoice(new DialogChoiceStep(this.questHelper.getConfig(), id, choice));
    }

    public void addDialogStep(int id, Pattern pattern) {
        this.choices.addChoice(new DialogChoiceStep(this.questHelper.getConfig(), id, pattern));
    }

    public void addDialogSteps(String ... newChoices) {
        for (String choice : newChoices) {
            this.choices.addChoice(new DialogChoiceStep(this.questHelper.getConfig(), choice));
        }
    }

    public void addDialogConsideringLastLineCondition(String dialogString, String choiceValue) {
        DialogChoiceStep choice = new DialogChoiceStep(this.questHelper.getConfig(), dialogString);
        choice.setExpectedPreviousLine(choiceValue);
        this.choices.addChoice(choice);
    }

    public void addDialogChange(String choice, String newText) {
        this.choices.addChoice(new DialogChoiceChange(this.questHelper.getConfig(), choice, newText));
    }

    public void addWidgetChoice(String text, int groupID, int childID) {
        this.widgetChoices.addChoice(new WidgetChoiceStep(this.questHelper.getConfig(), text, groupID, childID));
    }

    public void addWidgetChoice(String text, int groupID, int childID, int groupIDForChecking) {
        WidgetChoiceStep newChoice = new WidgetChoiceStep(this.questHelper.getConfig(), text, groupID, childID);
        newChoice.setGroupIdForChecking(groupIDForChecking);
        this.widgetChoices.addChoice(newChoice);
    }

    public void addWidgetChoice(int id, int groupID, int childID) {
        this.widgetChoices.addChoice(new WidgetChoiceStep(this.questHelper.getConfig(), id, groupID, childID));
    }

    public void addWidgetChange(String choice, int groupID, int childID, String newText) {
        this.widgetChoices.addChoice(new WidgetTextChange(this.questHelper.getConfig(), choice, groupID, childID, newText));
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.DIALOG) {
            this.lastDialogSeen = chatMessage.getMessage();
        }
    }

    public void clearWidgetHighlights() {
        this.widgetsToHighlight.clear();
    }

    public void addWidgetHighlight(int groupID, int childID) {
        this.widgetsToHighlight.add(new WidgetHighlights(groupID, childID));
    }

    public void addWidgetHighlightWithItemIdRequirement(int groupID, int childID, int itemID, boolean checkChildren) {
        this.widgetsToHighlight.add(new WidgetHighlights(groupID, childID, itemID, checkChildren));
    }

    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        this.addTitleToPanel(panelComponent);
        additionalText.stream().filter(s -> !s.isEmpty()).forEach(line -> this.addTextToPanel(panelComponent, (String)line));
        if (this.text != null && this.text.size() > 0 && !this.text.get(0).isEmpty()) {
            this.addTextToPanel(panelComponent, "");
        }
        if (!this.overlayText.isEmpty()) {
            this.overlayText.stream().filter(s -> !s.isEmpty()).forEach(line -> this.addTextToPanel(panelComponent, (String)line));
        } else if (this.text != null) {
            this.text.stream().filter(s -> !s.isEmpty()).forEach(line -> this.addTextToPanel(panelComponent, (String)line));
        }
    }

    private void addTitleToPanel(PanelComponent panelComponent) {
        panelComponent.getChildren().add(LineComponent.builder().left(this.questHelper.getQuest().getName()).build());
    }

    private void addTextToPanel(PanelComponent panelComponent, String line) {
        panelComponent.getChildren().add(LineComponent.builder().left(line).leftColor(QuestHelperOverlay.TITLED_CONTENT_COLOR).build());
    }

    public void addIcon(int iconItemID) {
        this.iconItemID = iconItemID;
    }

    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public void makeDirectionOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
    }

    public void setLockedManually(boolean isLocked) {
        this.locked = isLocked;
    }

    public boolean isLocked() {
        boolean autoLocked = this.lockingCondition != null && this.lockingCondition.check(this.client);
        boolean bl = this.unlockable = !autoLocked;
        if (autoLocked) {
            this.locked = true;
        }
        return this.locked;
    }

    public QuestStep getActiveStep() {
        return this;
    }

    public QuestStep getSidePanelStep() {
        return this.getActiveStep();
    }

    protected void setupIcon() {
        if (this.iconItemID != -1 && this.icon == null) {
            this.icon = IconOverlay.createIconImage((BufferedImage)this.itemManager.getImage(this.iconItemID));
        } else if (this.icon == null) {
            this.icon = this.getQuestImage();
        }
    }

    public void conditionToHideInSidebar(Requirement hideCondition) {
        this.conditionToHide = hideCondition;
    }

    public BufferedImage getQuestImage() {
        return this.spriteManager.getSprite(776, 0);
    }

    public List<String> getText() {
        return this.text;
    }

    public List<String> getOverlayText() {
        return this.overlayText;
    }

    public boolean isLockable() {
        return this.isLockable;
    }

    public void setLockable(boolean isLockable) {
        this.isLockable = isLockable;
    }

    public boolean isBlocker() {
        return this.blocker;
    }

    public void setBlocker(boolean blocker) {
        this.blocker = blocker;
    }

    public boolean isUnlockable() {
        return this.unlockable;
    }

    public Requirement getLockingCondition() {
        return this.lockingCondition;
    }

    public void setLockingCondition(Requirement lockingCondition) {
        this.lockingCondition = lockingCondition;
    }

    public void setAllowInCutscene(boolean allowInCutscene) {
        this.allowInCutscene = allowInCutscene;
    }

    public QuestHelper getQuestHelper() {
        return this.questHelper;
    }

    public DialogChoiceSteps getChoices() {
        return this.choices;
    }

    public WidgetChoiceSteps getWidgetChoices() {
        return this.widgetChoices;
    }

    public List<WidgetHighlights> getWidgetsToHighlight() {
        return this.widgetsToHighlight;
    }

    public List<QuestStep> getSubsteps() {
        return this.substeps;
    }

    public Requirement getConditionToHide() {
        return this.conditionToHide;
    }

    public boolean isShowInSidebar() {
        return this.showInSidebar;
    }

    public void setShowInSidebar(boolean showInSidebar) {
        this.showInSidebar = showInSidebar;
    }
}

