/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.WidgetDetails;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashSet;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class PuzzleStep
extends DetailedQuestStep {
    ButtonHighlighCalculator highlightCalculator;
    private HashSet<WidgetDetails> highlightedButtons = new HashSet();

    public PuzzleStep(QuestHelper questHelper, ButtonHighlighCalculator highlightCalculator, Requirement ... requirements) {
        this(questHelper, "Click the highlighted buttons to complete the puzzle", highlightCalculator, requirements);
    }

    public PuzzleStep(QuestHelper questHelper, String text, ButtonHighlighCalculator highlightCalculator, Requirement ... requirements) {
        super(questHelper, text, requirements);
        this.highlightCalculator = highlightCalculator;
    }

    @Override
    public void startUp() {
        this.highlightedButtons = this.highlightCalculator.getHighlightedButtons();
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        super.onGameTick(event);
        this.highlightedButtons = this.highlightCalculator.getHighlightedButtons();
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        for (WidgetDetails button : this.highlightedButtons) {
            Widget widget;
            if (button == null || (widget = this.client.getWidget(button.getGroupID(), button.getChildID())) == null) continue;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
        }
    }

    public static interface ButtonHighlighCalculator {
        public HashSet<WidgetDetails> getHighlightedButtons();
    }
}

