/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.overlay.DirectionArrow;
import com.questhelper.steps.tools.QuestPerspective;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ObjectStep
extends DetailedQuestStep {
    protected final ArrayList<Integer> alternateObjectIDs = new ArrayList();
    private final int objectID;
    private final List<TileObject> objects = new ArrayList<TileObject>();
    private boolean showAllInArea;
    private int maxObjectDistance = 50;
    private int maxRenderDistance = 50;
    private TileObject closestObject = null;
    private int lastPlane;
    private boolean revalidateObjects;

    public ObjectStep(QuestHelper questHelper, int objectID, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.objectID = objectID;
        this.showAllInArea = false;
    }

    public ObjectStep(QuestHelper questHelper, int objectID, WorldPoint worldPoint, String text, boolean showAllInArea, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.showAllInArea = showAllInArea;
        this.objectID = objectID;
    }

    public ObjectStep(QuestHelper questHelper, int objectID, String text, Requirement ... requirements) {
        super(questHelper, null, text, requirements);
        this.objectID = objectID;
    }

    public ObjectStep(QuestHelper questHelper, int objectID, String text, boolean showAllInArea, Requirement ... requirements) {
        super(questHelper, null, text, requirements);
        this.showAllInArea = showAllInArea;
        this.objectID = objectID;
    }

    public ObjectStep(QuestHelper questHelper, int objectID, WorldPoint worldPoint, String text, List<Requirement> requirements, List<Requirement> recommended) {
        super(questHelper, worldPoint, text, requirements, recommended);
        this.objectID = objectID;
        this.showAllInArea = false;
    }

    public ObjectStep copy() {
        ObjectStep newStep = new ObjectStep(this.getQuestHelper(), this.objectID, this.worldPoint, null, this.requirements, this.recommended);
        if (this.text != null) {
            newStep.setText(this.text);
        }
        newStep.showAllInArea = this.showAllInArea;
        newStep.addAlternateObjects(this.alternateObjectIDs);
        newStep.setMaxObjectDistance(this.maxObjectDistance);
        newStep.setMaxRenderDistance(this.maxRenderDistance);
        for (Requirement tp : this.teleport) {
            newStep.addTeleport(tp);
        }
        return newStep;
    }

    public void setRevalidateObjects(boolean value) {
        this.revalidateObjects = value;
    }

    @Override
    public void startUp() {
        super.startUp();
        if (this.worldPoint != null && !this.showAllInArea) {
            this.checkTileForObject(this.worldPoint);
        } else {
            this.loadObjects();
        }
    }

    protected void loadObjects() {
        Tile[][] tiles;
        this.objects.clear();
        Tile[][] tileArray = tiles = this.client.getScene().getTiles()[this.client.getPlane()];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] lineOfTiles;
            for (Tile tile : lineOfTiles = tileArray[i]) {
                if (tile == null) continue;
                for (GameObject object : tile.getGameObjects()) {
                    this.handleObjects((TileObject)object);
                }
                this.handleObjects((TileObject)tile.getDecorativeObject());
                this.handleObjects((TileObject)tile.getGroundObject());
                this.handleObjects((TileObject)tile.getWallObject());
            }
        }
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        super.onGameTick(event);
        if (this.revalidateObjects && this.lastPlane != this.client.getPlane()) {
            this.lastPlane = this.client.getPlane();
            this.loadObjects();
        }
        if (this.worldPoint == null || this.showAllInArea) {
            return;
        }
        this.closestObject = null;
        this.objects.clear();
        this.checkTileForObject(this.worldPoint);
    }

    public void checkTileForObject(WorldPoint wp) {
        LocalPoint localPoint = QuestPerspective.getInstanceLocalPointFromReal(this.client, wp);
        if (localPoint == null) {
            return;
        }
        Tile[][][] tiles = this.client.getScene().getTiles();
        Tile tile = tiles[this.client.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()];
        if (tile != null) {
            Arrays.stream(tile.getGameObjects()).forEach(this::handleObjects);
            this.handleObjects((TileObject)tile.getDecorativeObject());
            this.handleObjects((TileObject)tile.getGroundObject());
            this.handleObjects((TileObject)tile.getWallObject());
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.objects.clear();
    }

    @Override
    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        super.onGameStateChanged(event);
        if (event.getGameState() == GameState.LOADING) {
            this.closestObject = null;
            this.objects.clear();
        }
    }

    public void addAlternateObjects(Integer ... alternateObjectIDs) {
        this.alternateObjectIDs.addAll(Arrays.asList(alternateObjectIDs));
    }

    public void addAlternateObjects(Collection<Integer> alternateObjectIDs) {
        this.alternateObjectIDs.addAll(alternateObjectIDs);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.handleObjects((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.handleRemoveObjects((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.handleObjects((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.handleRemoveObjects((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.handleObjects((TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.handleRemoveObjects((TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.handleObjects((TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.handleRemoveObjects((TileObject)event.getWallObject());
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        Shape clickbox;
        super.makeWorldOverlayHint(graphics, plugin);
        if (this.objects.isEmpty()) {
            return;
        }
        if (this.inCutscene) {
            return;
        }
        Point mousePosition = this.client.getMouseCanvasPosition();
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint playerPosition = this.client.getLocalPlayer().getWorldLocation();
        for (TileObject tileObject : this.objects) {
            int distanceFromPlayer = tileObject.getWorldLocation().distanceTo(playerPosition);
            if (this.maxRenderDistance < distanceFromPlayer || tileObject.getPlane() != this.client.getPlane()) continue;
            if (this.closestObject == null || this.closestObject.getWorldLocation().distanceTo(playerPosition) > distanceFromPlayer) {
                this.closestObject = tileObject;
            }
            Color configColor = this.getQuestHelper().getConfig().targetOverlayColor();
            QuestHelperConfig.ObjectHighlightStyle highlightStyle = this.visibilityHelper.isObjectVisible(tileObject) ? this.questHelper.getConfig().highlightStyleObjects() : QuestHelperConfig.ObjectHighlightStyle.OUTLINE;
            switch (highlightStyle) {
                case CLICK_BOX: {
                    Color fillColor = new Color(configColor.getRed(), configColor.getGreen(), configColor.getBlue(), 20);
                    OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)tileObject.getClickbox(), (Point)mousePosition, (Color)fillColor, (Color)this.questHelper.getConfig().targetOverlayColor().darker(), (Color)this.questHelper.getConfig().targetOverlayColor());
                    break;
                }
                case OUTLINE: {
                    this.modelOutlineRenderer.drawOutline(tileObject, this.questHelper.getConfig().outlineThickness(), configColor, this.questHelper.getConfig().outlineFeathering());
                    break;
                }
            }
        }
        if (this.iconItemID != -1 && this.closestObject != null && (clickbox = this.closestObject.getClickbox()) != null && !this.inCutscene) {
            Rectangle2D boundingBox = clickbox.getBounds2D();
            graphics.drawImage((Image)this.icon, (int)boundingBox.getCenterX() - 15, (int)boundingBox.getCenterY() - 10, null);
        }
    }

    @Override
    protected void renderTileIcon(Graphics2D graphics) {
    }

    @Override
    public void renderArrow(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            if (this.closestObject == null || this.hideWorldArrow) {
                return;
            }
            Shape clickbox = this.closestObject.getClickbox();
            if (clickbox != null && this.questHelper.getConfig().showMiniMapArrow()) {
                Rectangle2D boundingBox = clickbox.getBounds2D();
                int x = (int)boundingBox.getCenterX();
                int y = (int)boundingBox.getMinY() - 20;
                DirectionArrow.drawWorldArrow(graphics, this.getQuestHelper().getConfig().targetOverlayColor(), x, y);
            }
        }
    }

    private void handleRemoveObjects(TileObject object) {
        if (object.equals(this.closestObject)) {
            this.closestObject = null;
        }
        this.objects.remove(object);
    }

    private void handleObjects(TileObject object) {
        if (object == null) {
            return;
        }
        if (object.getId() == this.objectID || this.alternateObjectIDs.contains(object.getId())) {
            this.setObjects(object);
            return;
        }
        ObjectComposition comp = this.client.getObjectDefinition(object.getId());
        int[] impostorIds = comp.getImpostorIds();
        if (impostorIds != null && comp.getImpostor() != null) {
            boolean imposterIsMainObject = comp.getImpostor().getId() == this.objectID;
            boolean imposterIsAlternateObject = this.alternateObjectIDs.contains(comp.getImpostor().getId());
            if (imposterIsMainObject || imposterIsAlternateObject) {
                this.setObjects(object);
            }
        }
    }

    private void setObjects(TileObject object) {
        if (this.worldPoint == null) {
            if (!this.objects.contains(object)) {
                this.objects.add(object);
            }
            return;
        }
        WorldPoint objectWP = QuestPerspective.getRealWorldPointFromLocal(this.client, object.getWorldLocation());
        if (objectWP == null) {
            return;
        }
        if (this.worldPoint.equals((Object)objectWP) || object instanceof GameObject && this.objZone((GameObject)object).contains(this.worldPoint)) {
            if (!this.objects.contains(object)) {
                this.objects.add(object);
            }
        } else if (this.showAllInArea && this.worldPoint != null && this.worldPoint.distanceTo(objectWP) < this.maxObjectDistance && !this.objects.contains(object)) {
            this.objects.add(object);
        }
    }

    private Zone objZone(GameObject obj) {
        WorldPoint bottomLeftCorner = QuestPerspective.getRealWorldPointFromLocal(this.client, obj.getWorldLocation());
        if (bottomLeftCorner == null) {
            return new Zone();
        }
        int bottomX = bottomLeftCorner.getX() - (obj.sizeX() - 1) / 2;
        int bottomY = bottomLeftCorner.getY() - (obj.sizeY() - 1) / 2;
        return new Zone(new WorldPoint(bottomX, bottomY, bottomLeftCorner.getPlane()), new WorldPoint(bottomX + obj.sizeX() - 1, bottomY + obj.sizeY() - 1, bottomLeftCorner.getPlane()));
    }

    public void setMaxObjectDistance(int maxObjectDistance) {
        this.maxObjectDistance = maxObjectDistance;
    }

    public void setMaxRenderDistance(int maxRenderDistance) {
        this.maxRenderDistance = maxRenderDistance;
    }
}

