/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperConfig;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.overlay.DirectionArrow;
import com.questhelper.steps.tools.QuestPerspective;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class NpcStep
extends DetailedQuestStep {
    @Inject
    protected Client client;
    private final int npcID;
    private final List<Integer> alternateNpcIDs = new ArrayList<Integer>();
    private boolean allowMultipleHighlights;
    private final ArrayList<NPC> npcs = new ArrayList();
    private int maxRoamRange = 48;
    private boolean mustBeFocused = false;
    private String npcName;

    public NpcStep(QuestHelper questHelper, int npcID, String text, Requirement ... requirements) {
        super(questHelper, text, requirements);
        this.npcID = npcID;
    }

    public NpcStep(QuestHelper questHelper, int[] npcID, String text, Requirement ... requirements) {
        super(questHelper, text, requirements);
        this.npcID = npcID[0];
        for (int i = 1; i < npcID.length; ++i) {
            this.alternateNpcIDs.add(npcID[i]);
        }
    }

    public NpcStep(QuestHelper questHelper, int npcID, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.npcID = npcID;
    }

    public NpcStep(QuestHelper questHelper, int npcID, String npcName, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.npcID = npcID;
        this.npcName = npcName;
    }

    public NpcStep(QuestHelper questHelper, int npcID, String npcName, WorldPoint worldPoint, String text, boolean allowMultipleHighlights, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.npcID = npcID;
        this.npcName = npcName;
        this.allowMultipleHighlights = allowMultipleHighlights;
    }

    public NpcStep(QuestHelper questHelper, int npcID, WorldPoint worldPoint, String text, List<Requirement> requirements, List<Requirement> optionalRequirements) {
        super(questHelper, worldPoint, text, requirements, optionalRequirements);
        this.npcID = npcID;
    }

    public NpcStep(QuestHelper questHelper, int npcID, WorldPoint worldPoint, String text, boolean allowMultipleHighlights, List<Requirement> requirements, List<Requirement> optionalRequirements) {
        super(questHelper, worldPoint, text, requirements, optionalRequirements);
        this.npcID = npcID;
        this.allowMultipleHighlights = allowMultipleHighlights;
    }

    public NpcStep(QuestHelper questHelper, int[] npcID, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.npcID = npcID[0];
        for (int i = 1; i < npcID.length; ++i) {
            this.alternateNpcIDs.add(npcID[i]);
        }
    }

    public NpcStep(QuestHelper questHelper, int npcID, WorldPoint worldPoint, String text, boolean allowMultipleHighlights, Requirement ... requirements) {
        this(questHelper, npcID, worldPoint, text, requirements);
        this.allowMultipleHighlights = allowMultipleHighlights;
    }

    public NpcStep(QuestHelper questHelper, int npcID, String text, boolean allowMultipleHighlights, Requirement ... requirements) {
        this(questHelper, npcID, null, text, allowMultipleHighlights, requirements);
    }

    public NpcStep copy() {
        NpcStep newStep = new NpcStep(this.getQuestHelper(), this.npcID, this.worldPoint, null, this.requirements, this.recommended);
        if (this.text != null) {
            newStep.setText(this.text);
        }
        newStep.allowMultipleHighlights = this.allowMultipleHighlights;
        newStep.addAlternateNpcs(this.alternateNpcIDs);
        if (this.mustBeFocused) {
            newStep.setMustBeFocused(true);
        }
        newStep.setMaxRoamRange(this.maxRoamRange);
        return newStep;
    }

    private boolean npcPassesChecks(NPC npc) {
        if (!(this.npcName == null || npc.getName() != null && npc.getName().equals(this.npcName))) {
            return false;
        }
        return this.npcID == npc.getId() || this.alternateNpcIDs.contains(npc.getId());
    }

    @Override
    public void startUp() {
        super.startUp();
        this.scanForNpcs();
    }

    public void scanForNpcs() {
        for (NPC npc : this.client.getNpcs()) {
            if (!this.npcPassesChecks(npc)) continue;
            WorldPoint npcPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)npc.getLocalLocation());
            if (this.npcs.size() == 0 && (this.worldPoint == null || npcPoint.distanceTo(this.worldPoint) < this.maxRoamRange)) {
                this.npcs.add(npc);
                continue;
            }
            if (!this.allowMultipleHighlights) continue;
            this.npcs.add(npc);
        }
    }

    public void addAlternateNpcs(Integer ... alternateNpcIDs) {
        this.alternateNpcIDs.addAll(Arrays.asList(alternateNpcIDs));
    }

    public void addAlternateNpcs(List<Integer> alternateNpcIDs) {
        this.alternateNpcIDs.addAll(alternateNpcIDs);
    }

    public List<Integer> allIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(this.npcID);
        ids.addAll(this.alternateNpcIDs);
        return ids;
    }

    public void setMustBeFocused(boolean mustBeFocused) {
        this.mustBeFocused = mustBeFocused;
        if (mustBeFocused) {
            this.allowMultipleHighlights = true;
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.npcs.clear();
    }

    @Override
    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        super.onGameStateChanged(event);
        if (event.getGameState() == GameState.HOPPING) {
            this.npcs.clear();
        } else if (event.getGameState() == GameState.LOGGED_IN) {
            this.scanForNpcs();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (this.npcPassesChecks(event.getNpc())) {
            WorldPoint npcPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)event.getNpc().getLocalLocation());
            if (this.npcs.size() == 0) {
                if (this.worldPoint == null) {
                    this.npcs.add(event.getNpc());
                } else if (npcPoint.distanceTo(this.worldPoint) < this.maxRoamRange) {
                    this.npcs.add(event.getNpc());
                }
            } else if (this.allowMultipleHighlights && (this.worldPoint == null || npcPoint.distanceTo(this.worldPoint) < this.maxRoamRange)) {
                this.npcs.add(event.getNpc());
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        this.npcs.remove(event.getNpc());
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        int newNpcId = npcChanged.getNpc().getId();
        this.npcs.remove(npcChanged.getNpc());
        if (this.allIds().contains(newNpcId) && npcChanged.getNpc().getComposition().isVisible() && (this.npcs.size() == 0 || this.allowMultipleHighlights)) {
            this.npcs.add(npcChanged.getNpc());
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        Collection<WorldPoint> localWorldPoints;
        this.npcs.removeIf(npc -> npc.getId() == -1);
        super.makeWorldOverlayHint(graphics, plugin);
        if (this.worldPoint != null && (localWorldPoints = QuestPerspective.toLocalInstanceFromReal(this.client, this.worldPoint)).isEmpty()) {
            return;
        }
        Color configColor = this.getQuestHelper().getConfig().targetOverlayColor();
        for (NPC npc2 : this.npcs) {
            int zOffset;
            Point imageLocation;
            if (this.mustBeFocused && npc2.getInteracting() != this.client.getLocalPlayer()) continue;
            this.highlightNpc(npc2, configColor, graphics);
            if (!this.questHelper.getConfig().showSymbolOverlay() || (imageLocation = npc2.getCanvasImageLocation(this.icon, zOffset = this.questHelper.getConfig().highlightStyleNpcs() == QuestHelperConfig.NpcHighlightStyle.TILE ? 30 : npc2.getLogicalHeight() / 2)) == null) continue;
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)imageLocation, (BufferedImage)this.icon);
        }
    }

    @Override
    protected void renderTileIcon(Graphics2D graphics) {
    }

    private void highlightNpc(NPC npc, Color color, Graphics2D graphics) {
        switch (this.questHelper.getConfig().highlightStyleNpcs()) {
            case CONVEX_HULL: {
                OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)npc.getConvexHull(), (Point)this.client.getMouseCanvasPosition(), (Color)ColorUtil.colorWithAlpha((Color)color, (int)20), (Color)this.questHelper.getConfig().targetOverlayColor().darker(), (Color)this.questHelper.getConfig().targetOverlayColor());
                break;
            }
            case OUTLINE: {
                this.modelOutlineRenderer.drawOutline(npc, this.questHelper.getConfig().outlineThickness(), color, this.questHelper.getConfig().outlineFeathering());
                break;
            }
            case TILE: {
                Polygon poly = npc.getCanvasTilePoly();
                if (poly == null) break;
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
                break;
            }
        }
    }

    @Override
    public void renderArrow(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            Shape hull;
            if (this.npcs.size() == 0) {
                super.renderArrow(graphics);
            } else if (!this.hideWorldArrow && !this.npcs.contains(this.client.getHintArrowNpc()) && (hull = this.npcs.get(0).getConvexHull()) != null) {
                Rectangle rect = hull.getBounds();
                int x = (int)rect.getCenterX();
                int y = (int)rect.getMinY() - this.ARROW_SHIFT_Y;
                DirectionArrow.drawWorldArrow(graphics, this.getQuestHelper().getConfig().targetOverlayColor(), x, y);
            }
        }
    }

    @Override
    public void renderMinimapArrow(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            if (this.npcs.contains(this.client.getHintArrowNpc())) {
                return;
            }
            if (!this.npcs.isEmpty() && this.npcs.get(0).getMinimapLocation() != null) {
                int x = this.npcs.get(0).getMinimapLocation().getX();
                int y = this.npcs.get(0).getMinimapLocation().getY();
                Line2D.Double line = new Line2D.Double(x, y - 18, x, y - 8);
                DirectionArrow.drawMinimapArrow(graphics, line, this.getQuestHelper().getConfig().targetOverlayColor());
                return;
            }
            super.renderMinimapArrow(graphics);
        }
    }

    public void setAllowMultipleHighlights(boolean allowMultipleHighlights) {
        this.allowMultipleHighlights = allowMultipleHighlights;
    }

    public void setMaxRoamRange(int maxRoamRange) {
        this.maxRoamRange = maxRoamRange;
    }

    public void setNpcName(String npcName) {
        this.npcName = npcName;
    }
}

