/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.emote.QuestEmote;
import com.questhelper.steps.overlay.IconOverlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;

public class EmoteStep
extends DetailedQuestStep {
    private boolean hasScrolled;
    private final QuestEmote emote;

    public EmoteStep(QuestHelper questHelper, QuestEmote emote, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.emote = emote;
    }

    public EmoteStep(QuestHelper questHelper, QuestEmote emote, String text, Requirement ... requirements) {
        super(questHelper, text, requirements);
        this.emote = emote;
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget emoteContainer = this.client.getWidget(14155778);
        if (emoteContainer == null || emoteContainer.isHidden()) {
            return;
        }
        Widget emoteWindow = this.client.getWidget(0xD80000);
        if (emoteWindow == null) {
            return;
        }
        Widget finalEmoteWidget = null;
        for (Widget emoteWidget : emoteContainer.getDynamicChildren()) {
            if (emoteWidget.getSpriteId() != this.emote.getSpriteId()) continue;
            finalEmoteWidget = emoteWidget;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(emoteWidget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(emoteWidget.getBounds());
        }
        if (!this.hasScrolled) {
            this.hasScrolled = true;
            this.scrollToWidget(finalEmoteWidget);
        }
    }

    void scrollToWidget(Widget widget) {
        Widget parent = this.client.getWidget(14155778);
        if (widget == null || parent == null) {
            return;
        }
        int newScroll = Math.max(0, Math.min(parent.getScrollHeight(), widget.getRelativeY() + widget.getHeight() / 2 - parent.getHeight() / 2));
        this.client.runScript(new Object[]{72, 14155780, 14155778, newScroll});
    }

    @Override
    protected void setupIcon() {
        BufferedImage emoteImage;
        if (this.emote.getSpriteId() != -1 && this.icon == null && (emoteImage = this.spriteManager.getSprite(this.emote.getSpriteId(), 0)) != null) {
            this.icon = IconOverlay.createIconImage(emoteImage);
        }
        super.setupIcon();
    }
}

