/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.InventorySlots;
import com.questhelper.steps.DetailedQuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.OverlayUtil;

public class DigStep
extends DetailedQuestStep {
    private final ItemRequirement SPADE = new ItemRequirement("Spade", 952);
    private Predicate<Item> expectedItemPredicate = i -> i.getId() == -1;
    private boolean hasExpectedItem = false;

    public DigStep(QuestHelper questHelper, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, worldPoint, text, requirements);
        this.getRequirements().add(this.SPADE);
    }

    public void setExpectedItem(int itemID) {
        this.setExpectedItem(i -> i.getId() == itemID);
    }

    public void setExpectedItem(Predicate<Item> predicate) {
        this.expectedItemPredicate = predicate == null ? i -> true : predicate;
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        super.onGameTick(event);
        this.hasExpectedItem = InventorySlots.INVENTORY_SLOTS.contains(this.client, this.expectedItemPredicate);
        if (!this.hasExpectedItem) {
            Player player = this.client.getLocalPlayer();
            if (player == null) {
                return;
            }
            WorldPoint targetLocation = this.worldPoint;
            boolean shouldHighlightSpade = targetLocation.isInScene(this.client);
            this.SPADE.setHighlightInInventory(shouldHighlightSpade);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWorldOverlayHint(graphics, plugin);
        if (this.inCutscene) {
            return;
        }
        LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.worldPoint);
        if (localLocation == null) {
            return;
        }
        OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)localLocation, (BufferedImage)this.getSpadeImage(), (Color)this.questHelper.getConfig().targetOverlayColor());
    }

    private BufferedImage getSpadeImage() {
        return this.itemManager.getImage(952);
    }
}

