/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.bank.QuestBank;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetHighlights;
import com.questhelper.steps.overlay.DirectionArrow;
import com.questhelper.steps.overlay.WorldLines;
import com.questhelper.steps.tools.QuestPerspective;
import com.questhelper.tools.QuestHelperWorldMapPoint;
import com.questhelper.tools.QuestTile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class DetailedQuestStep
extends QuestStep {
    @Inject
    WorldMapPointManager worldMapPointManager;
    @Inject
    private QuestBank questBank;
    protected WorldPoint worldPoint;
    protected WorldPoint worldMapPoint;
    protected List<WorldPoint> linePoints;
    protected List<WorldPoint> worldLinePoints;
    private final List<QuestTile> markedTiles = new ArrayList<QuestTile>();
    protected final List<Requirement> requirements = new ArrayList<Requirement>();
    protected final List<Requirement> recommended = new ArrayList<Requirement>();
    protected final List<Requirement> teleport = new ArrayList<Requirement>();
    protected Multimap<Tile, Integer> tileHighlights = ArrayListMultimap.create();
    protected QuestHelperWorldMapPoint mapPoint;
    protected static final int MAX_DISTANCE = 2350;
    protected int currentRender = 0;
    protected final int MAX_RENDER_SIZE = 4;
    protected boolean started;
    protected boolean hideWorldArrow;
    protected boolean hideMinimapLines;
    public boolean hideRequirements;
    public boolean considerBankForItemHighlight;
    public int iconToUseForNeededItems = -1;

    public DetailedQuestStep(QuestHelper questHelper, String text, Requirement ... requirements) {
        super(questHelper, text);
        this.requirements.addAll(Arrays.asList(requirements));
    }

    public DetailedQuestStep(QuestHelper questHelper, String text, List<Requirement> requirements) {
        super(questHelper, text);
        this.requirements.addAll(requirements);
    }

    public DetailedQuestStep(QuestHelper questHelper, WorldPoint worldPoint, String text, Requirement ... requirements) {
        super(questHelper, text);
        this.worldPoint = worldPoint;
        this.requirements.addAll(Arrays.asList(requirements));
    }

    public DetailedQuestStep(QuestHelper questHelper, WorldPoint worldPoint, String text, List<Requirement> requirements, List<Requirement> recommended) {
        super(questHelper, text);
        this.worldPoint = worldPoint;
        if (requirements != null) {
            this.requirements.addAll(requirements);
        }
        if (recommended != null) {
            this.recommended.addAll(recommended);
        }
    }

    public DetailedQuestStep(QuestHelper questHelper, String text, List<Requirement> requirements, List<Requirement> recommended) {
        this(questHelper, null, text, requirements, recommended);
    }

    @Override
    public void startUp() {
        super.startUp();
        if (this.worldMapPoint != null) {
            this.mapPoint = new QuestHelperWorldMapPoint(this.worldMapPoint, this.getQuestImage());
            this.worldMapPointManager.add((WorldMapPoint)this.mapPoint);
        } else if (this.worldPoint != null) {
            this.mapPoint = new QuestHelperWorldMapPoint(this.worldPoint, this.getQuestImage());
            this.worldMapPointManager.add((WorldMapPoint)this.mapPoint);
        }
        this.addItemTiles(this.requirements);
        this.addItemTiles(this.recommended);
        this.started = true;
    }

    @Override
    public void shutDown() {
        this.worldMapPointManager.removeIf(QuestHelperWorldMapPoint.class::isInstance);
        this.tileHighlights.clear();
        this.started = false;
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public void addRequirement(Requirement ... requirements) {
        this.requirements.addAll(Arrays.asList(requirements));
    }

    public void addItemRequirements(List<ItemRequirement> requirement) {
        this.requirements.addAll(requirement);
    }

    public void emptyRequirements() {
        this.requirements.clear();
    }

    public void setRequirements(List<? extends Requirement> newRequirements) {
        this.requirements.clear();
        this.requirements.addAll(newRequirements);
    }

    public void addRecommended(Requirement newRecommended) {
        this.recommended.add(newRecommended);
    }

    public void setRecommended(List<Requirement> newRecommended) {
        this.recommended.clear();
        this.recommended.addAll(newRecommended);
    }

    public void addTeleport(Requirement newTeleport) {
        this.teleport.add(newTeleport);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.tileHighlights.clear();
        }
    }

    public void setWorldPoint(WorldPoint worldPoint) {
        this.worldPoint = worldPoint;
        if (this.worldMapPoint == null && this.started) {
            if (this.mapPoint != null) {
                this.worldMapPointManager.remove((WorldMapPoint)this.mapPoint);
            }
            if (worldPoint != null) {
                this.mapPoint = new QuestHelperWorldMapPoint(worldPoint, this.getQuestImage());
                this.worldMapPointManager.add((WorldMapPoint)this.mapPoint);
            } else {
                this.mapPoint = null;
            }
        }
    }

    public void setWorldPoint(int x, int y, int z) {
        this.setWorldPoint(new WorldPoint(x, y, z));
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.inCutscene) {
            return;
        }
        if (!this.markedTiles.isEmpty()) {
            for (QuestTile location : this.markedTiles) {
                BufferedImage combatIcon = this.spriteManager.getSprite(location.getIconID(), 0);
                LocalPoint localPoint = QuestPerspective.getInstanceLocalPointFromReal(this.client, location.getWorldPoint());
                if (localPoint == null) continue;
                OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (BufferedImage)combatIcon, (Color)this.questHelper.getConfig().targetOverlayColor());
            }
        }
        this.tileHighlights.keySet().forEach(tile -> this.checkAllTilesForHighlighting((Tile)tile, this.tileHighlights.get(tile), graphics));
        this.renderTileIcon(graphics);
    }

    protected void renderTileIcon(Graphics2D graphics) {
        LocalPoint lp = QuestPerspective.getInstanceLocalPointFromReal(this.client, this.worldPoint);
        if (lp != null && this.icon != null && this.iconItemID != -1) {
            OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (BufferedImage)this.icon, (Color)this.questHelper.getConfig().targetOverlayColor());
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.currentRender = (this.currentRender + 1) % 4;
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.inCutscene) {
            return;
        }
        if (this.currentRender < 2) {
            this.renderArrow(graphics);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.inCutscene) {
            return;
        }
        if (this.linePoints != null && this.linePoints.size() > 1) {
            WorldLines.drawLinesOnWorld(graphics, this.client, this.linePoints, this.getQuestHelper().getConfig().targetOverlayColor());
        }
    }

    public void renderArrow(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            if (this.worldPoint == null || this.hideWorldArrow) {
                return;
            }
            LocalPoint lp = QuestPerspective.getInstanceLocalPointFromReal(this.client, this.worldPoint);
            if (lp == null) {
                return;
            }
            Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp, (int)30);
            if (poly == null || poly.getBounds() == null) {
                return;
            }
            int startX = poly.getBounds().x + poly.getBounds().width / 2;
            int startY = poly.getBounds().y + poly.getBounds().height / 2;
            DirectionArrow.drawWorldArrow(graphics, this.getQuestHelper().getConfig().targetOverlayColor(), startX, startY);
        }
    }

    public void addTileMarker(QuestTile questTile) {
        this.markedTiles.add(questTile);
    }

    public void addTileMarker(WorldPoint worldPoint, int spriteID) {
        this.markedTiles.add(new QuestTile(worldPoint, spriteID));
    }

    public void addTileMarkers(WorldPoint ... worldPoints) {
        for (WorldPoint point : worldPoints) {
            this.markedTiles.add(new QuestTile(point));
        }
    }

    public void addSafeSpots(WorldPoint ... worldPoints) {
        for (WorldPoint worldPoint : worldPoints) {
            this.markedTiles.add(new QuestTile(worldPoint, 168));
        }
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.hideRequirements) {
            return;
        }
        this.renderInventory(graphics);
        for (WidgetHighlights widgetHighlights : this.widgetsToHighlight) {
            widgetHighlights.highlightChoices(graphics, this.client, plugin);
        }
    }

    @Override
    public void makeDirectionOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (!this.hideMinimapLines && plugin.getConfig().showWorldLines()) {
            WorldLines.createMinimapLines(graphics, this.client, this.linePoints, this.getQuestHelper().getConfig().targetOverlayColor());
        }
        this.renderMapLines(graphics);
        this.renderMapArrows(graphics);
    }

    public void renderMapArrows(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            if (this.mapPoint == null) {
                return;
            }
            if (this.inCutscene) {
                return;
            }
            WorldPoint point = this.mapPoint.getWorldPoint();
            if (this.currentRender < 2) {
                this.renderMinimapArrow(graphics);
            }
            Rectangle mapViewArea = QuestPerspective.getWorldMapClipArea(this.client);
            Point drawPoint = QuestPerspective.mapWorldPointToGraphicsPoint(this.client, point);
            DirectionArrow.renderWorldMapArrow(mapViewArea, drawPoint, this.mapPoint);
        }
    }

    public void renderMapLines(Graphics2D graphics) {
        if (this.linePoints == null || this.linePoints.size() < 2) {
            return;
        }
        List<WorldPoint> worldMapLines = this.linePoints;
        if (this.worldLinePoints != null && this.worldLinePoints.size() > 1) {
            worldMapLines = this.worldLinePoints;
        }
        WorldLines.createWorldMapLines(graphics, this.client, worldMapLines, this.getQuestHelper().getConfig().targetOverlayColor());
    }

    public void renderMinimapArrow(Graphics2D graphics) {
        if (this.questHelper.getConfig().showMiniMapArrow()) {
            DirectionArrow.renderMinimapArrow(graphics, this.client, this.worldPoint, this.getQuestHelper().getConfig().targetOverlayColor());
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        super.makeOverlayHint(panelComponent, plugin, additionalText, new ArrayList<Requirement>());
        if (this.inCutscene || this.hideRequirements) {
            return;
        }
        if (!this.requirements.isEmpty() || !additionalRequirements.isEmpty()) {
            panelComponent.getChildren().add(LineComponent.builder().left("Requirements:").build());
        }
        Stream stream = this.requirements.stream();
        if (!additionalRequirements.isEmpty()) {
            stream = Stream.concat(stream, additionalRequirements.stream());
        }
        stream.distinct().filter(Objects::nonNull).map(req -> req.getDisplayTextWithChecks(this.client, this.questHelper.getConfig())).flatMap(Collection::stream).forEach(line -> panelComponent.getChildren().add(line));
        if (!this.recommended.isEmpty()) {
            panelComponent.getChildren().add(LineComponent.builder().left("Recommended:").build());
        }
        Stream streamRecommended = this.recommended.stream();
        streamRecommended.distinct().filter(Objects::nonNull).map(req -> req.getDisplayTextWithChecks(this.client, this.questHelper.getConfig())).flatMap(Collection::stream).forEach(line -> panelComponent.getChildren().add(line));
        if (!this.teleport.isEmpty()) {
            panelComponent.getChildren().add(LineComponent.builder().left("Teleport:").build());
        }
        Stream streamTeleport = this.teleport.stream();
        streamTeleport.distinct().map(req -> req.getDisplayTextWithChecks(this.client, this.questHelper.getConfig())).flatMap(Collection::stream).forEach(line -> panelComponent.getChildren().add(line));
    }

    protected Widget getInventoryWidget() {
        return this.client.getWidget(0x950000);
    }

    private void renderInventory(Graphics2D graphics) {
        Widget inventoryWidget = this.getInventoryWidget();
        if (inventoryWidget == null || inventoryWidget.isHidden()) {
            return;
        }
        Color baseColor = this.questHelper.getConfig().targetOverlayColor();
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        WorldPoint goalWp = QuestPerspective.getInstanceWorldPointFromReal(this.client, this.worldPoint);
        if (goalWp == null || playerLocation.distanceTo(goalWp) > 100) {
            for (Requirement requirement : this.teleport) {
                for (Widget item : inventoryWidget.getDynamicChildren()) {
                    if (!(requirement instanceof ItemRequirement) || !((ItemRequirement)requirement).getAllIds().contains(item.getItemId())) continue;
                    this.highlightInventoryItem(item, baseColor, graphics);
                }
            }
        }
        if (this.requirements.isEmpty()) {
            return;
        }
        if (inventoryWidget.getDynamicChildren() == null) {
            return;
        }
        for (Widget item : inventoryWidget.getDynamicChildren()) {
            for (Requirement requirement : this.requirements) {
                if (!this.isValidRequirementForRenderInInventory(requirement, item)) continue;
                this.highlightInventoryItem(item, baseColor, graphics);
            }
        }
    }

    private void highlightInventoryItem(Widget item, Color color, Graphics2D graphics) {
        Rectangle slotBounds = item.getBounds();
        switch (this.questHelper.getConfig().highlightStyleInventoryItems()) {
            case SQUARE: {
                graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)65));
                graphics.fill(slotBounds);
                graphics.setColor(color);
                graphics.draw(slotBounds);
                break;
            }
            case OUTLINE: {
                BufferedImage outlined = this.itemManager.getItemOutline(item.getItemId(), 1, color);
                graphics.drawImage((Image)outlined, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
                break;
            }
            case FILLED_OUTLINE: {
                BufferedImage outline = this.itemManager.getItemOutline(item.getItemId(), 1, color);
                graphics.drawImage((Image)outline, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
                BufferedImage image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(item.getItemId(), 1, false), (Color)ColorUtil.colorWithAlpha((Color)color, (int)65));
                graphics.drawImage((Image)image, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
                break;
            }
        }
    }

    private boolean isValidRequirementForRenderInInventory(Requirement requirement, Widget item) {
        return requirement instanceof ItemRequirement && this.isValidRenderRequirementInInventory((ItemRequirement)requirement, item);
    }

    private boolean isValidRenderRequirementInInventory(ItemRequirement requirement, Widget item) {
        return requirement.shouldHighlightInInventory(this.client) && requirement.getAllIds().contains(item.getItemId());
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        for (Requirement requirement : this.requirements) {
            if (!this.isItemRequirement(requirement) || !this.requirementContainsID((ItemRequirement)requirement, item.getId())) continue;
            this.tileHighlights.get((Object)tile).add(itemSpawned.getItem().getId());
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        Tile tile = itemDespawned.getTile();
        if (this.tileHighlights.containsKey((Object)tile)) {
            for (Requirement requirement : this.requirements) {
                if (!this.isItemRequirement(requirement) || !this.requirementContainsID((ItemRequirement)requirement, itemDespawned.getItem().getId())) continue;
                this.tileHighlights.get((Object)tile).remove(itemDespawned.getItem().getId());
            }
        }
    }

    protected void addItemTiles(Collection<Requirement> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            return;
        }
        Tile[][] squareOfTiles = this.client.getScene().getTiles()[this.client.getPlane()];
        List tiles = Stream.of(squareOfTiles).flatMap(Arrays::stream).filter(Objects::nonNull).collect(Collectors.toList());
        for (Tile tile : tiles) {
            List items = tile.getGroundItems();
            if (items == null) continue;
            block1: for (TileItem item : items) {
                if (item == null) continue;
                for (Requirement requirement : requirements) {
                    if (!this.isValidRequirementForTileItem(requirement, item)) continue;
                    this.tileHighlights.get((Object)tile).add(item.getId());
                    continue block1;
                }
            }
        }
    }

    private boolean isValidRequirementForTileItem(Requirement requirement, TileItem item) {
        return this.isItemRequirement(requirement) && this.requirementMatchesTileItem((ItemRequirement)requirement, item);
    }

    private boolean isItemRequirement(Requirement requirement) {
        return requirement != null && requirement.getClass() == ItemRequirement.class;
    }

    private boolean requirementMatchesTileItem(ItemRequirement requirement, TileItem item) {
        return this.requirementIsItem(requirement) && this.requirementContainsID(requirement, item.getId());
    }

    private boolean requirementIsItem(ItemRequirement requirement) {
        return requirement.isActualItem();
    }

    private boolean requirementContainsID(ItemRequirement requirement, int id) {
        return requirement.getAllIds().contains(id);
    }

    private boolean requirementContainsID(ItemRequirement requirement, Collection<Integer> ids) {
        return ids.stream().anyMatch(id -> this.requirementContainsID(requirement, (int)id));
    }

    private void checkAllTilesForHighlighting(Tile tile, Collection<Integer> ids, Graphics2D graphics) {
        if (this.inCutscene) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        LocalPoint playerLocation = player.getLocalLocation();
        if (!ids.isEmpty()) {
            LocalPoint location = tile.getLocalLocation();
            if (location == null) {
                return;
            }
            if (location.distanceTo(playerLocation) > 2350) {
                return;
            }
            Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)location);
            if (poly == null) {
                return;
            }
            Color highlightColor = this.questHelper.getConfig().targetOverlayColor();
            for (Requirement requirement : this.requirements) {
                if (!this.isReqValidForHighlighting(requirement, ids)) continue;
                if (this.iconToUseForNeededItems != -1) {
                    BufferedImage icon = this.spriteManager.getSprite(this.iconToUseForNeededItems, 0);
                    LocalPoint localPoint = QuestPerspective.getInstanceLocalPointFromReal(this.client, tile.getWorldLocation());
                    if (localPoint != null) {
                        OverlayUtil.renderTileOverlay((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (BufferedImage)icon, (Color)this.questHelper.getConfig().targetOverlayColor());
                    }
                } else {
                    this.highlightGroundItem(tile, highlightColor, graphics, poly);
                }
                return;
            }
        }
    }

    private void highlightGroundItem(Tile tile, Color color, Graphics2D graphics, Polygon poly) {
        switch (this.questHelper.getConfig().highlightStyleGroundItems()) {
            case CLICK_BOX: {
                break;
            }
            case OUTLINE: {
                this.modelOutlineRenderer.drawOutline((TileObject)tile.getItemLayer(), this.questHelper.getConfig().outlineThickness(), color, this.questHelper.getConfig().outlineFeathering());
                break;
            }
            case TILE: {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
                break;
            }
        }
    }

    private boolean isReqValidForHighlighting(Requirement requirement, Collection<Integer> ids) {
        return this.isItemRequirement(requirement) && this.requirementIsItem((ItemRequirement)requirement) && this.requirementContainsID((ItemRequirement)requirement, ids) && ((ItemRequirement)requirement).shouldRenderItemHighlights(this.client) && (!this.considerBankForItemHighlight && !requirement.check(this.client) || this.considerBankForItemHighlight && !((ItemRequirement)requirement).check(this.client, false, this.questBank.getBankItems()));
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public void setWorldMapPoint(WorldPoint worldMapPoint) {
        this.worldMapPoint = worldMapPoint;
    }

    public void setLinePoints(List<WorldPoint> linePoints) {
        this.linePoints = linePoints;
    }

    public void setWorldLinePoints(List<WorldPoint> worldLinePoints) {
        this.worldLinePoints = worldLinePoints;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Requirement> getRecommended() {
        return this.recommended;
    }

    public List<Requirement> getTeleport() {
        return this.teleport;
    }

    public void setHideWorldArrow(boolean hideWorldArrow) {
        this.hideWorldArrow = hideWorldArrow;
    }

    public void setHideMinimapLines(boolean hideMinimapLines) {
        this.hideMinimapLines = hideMinimapLines;
    }
}

