/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class DetailedOwnerStep
extends QuestStep
implements OwnerStep {
    protected QuestStep currentStep;
    protected List<Requirement> requirements = new ArrayList<Requirement>();
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;

    public DetailedOwnerStep(QuestHelper questHelper, Requirement ... requirements) {
        super(questHelper);
        this.requirements.addAll(Arrays.asList(requirements));
        this.setupSteps();
        this.addSubSteps(this.getSteps());
    }

    public DetailedOwnerStep(QuestHelper questHelper, String text, Requirement ... requirements) {
        super(questHelper, text);
        this.requirements.addAll(Arrays.asList(requirements));
        this.setupSteps();
        this.addSubSteps(this.getSteps());
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.currentStep = step;
            this.eventBus.register((Object)this.currentStep);
            this.currentStep.startUp();
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    protected void updateSteps() {
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>(additionalRequirements);
        allRequirements.addAll(this.requirements);
        ArrayList<String> allAdditionalText = new ArrayList<String>(additionalText);
        if (this.text != null) {
            allAdditionalText.addAll(this.text);
        }
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, allAdditionalText, allRequirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != null) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    protected void setupSteps() {
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return null;
    }
}

