/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.steps;

import com.google.inject.Inject;
import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.InitializableRequirement;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.steps.OwnerStep;
import com.questhelper.steps.QuestStep;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class ConditionalStep
extends QuestStep
implements OwnerStep {
    @Inject
    protected EventBus eventBus;
    protected boolean started = false;
    protected final LinkedHashMap<Requirement, QuestStep> steps;
    protected final List<ChatMessageRequirement> chatConditions = new ArrayList<ChatMessageRequirement>();
    protected final List<NpcCondition> npcConditions = new ArrayList<NpcCondition>();
    protected final List<DialogRequirement> dialogConditions = new ArrayList<DialogRequirement>();
    protected final List<RuneliteRequirement> runeliteConditions = new ArrayList<RuneliteRequirement>();
    protected QuestStep currentStep;
    protected List<Requirement> requirements = new ArrayList<Requirement>();

    public ConditionalStep(QuestHelper questHelper, QuestStep step, Requirement ... requirements) {
        super(questHelper);
        this.requirements.addAll(Arrays.asList(requirements));
        this.steps = new LinkedHashMap();
        this.steps.put(null, step);
    }

    public ConditionalStep(QuestHelper questHelper, QuestStep step, String text, Requirement ... requirements) {
        super(questHelper, text);
        this.requirements.addAll(Arrays.asList(requirements));
        this.steps = new LinkedHashMap();
        this.steps.put(null, step);
    }

    public void addStep(Requirement requirement, QuestStep step) {
        this.addStep(requirement, step, false);
    }

    public void addStep(Requirement requirement, QuestStep step, boolean isLockable) {
        step.setLockable(isLockable);
        this.steps.put(requirement, step);
        this.checkForConditions(requirement);
    }

    private void checkForConditions(Requirement requirement) {
        this.checkForChatConditions(requirement);
        this.checkForDialogConditions(requirement);
        this.checkForNpcConditions(requirement);
        this.checkForRuneliteConditions(requirement);
        if (requirement instanceof InitializableRequirement) {
            ((InitializableRequirement)requirement).getConditions().forEach(this::checkForConditions);
        }
        if (requirement instanceof RuneliteRequirement) {
            ((RuneliteRequirement)requirement).getRequirements().values().forEach(this::checkForConditions);
        }
    }

    public void checkForChatConditions(Requirement requirement) {
        if (!(requirement instanceof InitializableRequirement)) {
            return;
        }
        InitializableRequirement condition = (InitializableRequirement)requirement;
        if (condition instanceof ChatMessageRequirement && !this.chatConditions.contains(condition)) {
            this.chatConditions.add((ChatMessageRequirement)condition);
        }
        condition.getConditions().forEach(this::checkForChatConditions);
    }

    public void checkForDialogConditions(Requirement requirement) {
        if (requirement instanceof DialogRequirement && !this.dialogConditions.contains(requirement)) {
            DialogRequirement runeliteReq = (DialogRequirement)requirement;
            this.dialogConditions.add(runeliteReq);
        }
    }

    public void checkForNpcConditions(Requirement requirement) {
        if (!(requirement instanceof InitializableRequirement)) {
            return;
        }
        InitializableRequirement condition = (InitializableRequirement)requirement;
        if (condition.getConditions().isEmpty() && condition instanceof NpcCondition && !this.npcConditions.contains(condition)) {
            this.npcConditions.add((NpcCondition)condition);
        }
    }

    public void checkForRuneliteConditions(Requirement requirement) {
        if (requirement instanceof RuneliteRequirement && !this.runeliteConditions.contains(requirement)) {
            RuneliteRequirement runeliteReq = (RuneliteRequirement)requirement;
            this.runeliteConditions.add(runeliteReq);
        }
    }

    @Override
    public void startUp() {
        this.steps.keySet().stream().filter(InitializableRequirement.class::isInstance).forEach(req -> ((InitializableRequirement)req).initialize(this.client));
        this.updateSteps();
        this.started = true;
    }

    @Override
    public void shutDown() {
        this.started = false;
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.started) {
            for (RuneliteRequirement runeliteCondition : this.runeliteConditions) {
                runeliteCondition.validateCondition(this.client);
            }
            this.updateSteps();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        block3: {
            block2: {
                if (event.getGameState() == GameState.LOADING) break block2;
                if (event.getGameState() != GameState.HOPPING) break block3;
            }
            this.steps.keySet().stream().filter(Objects::nonNull).filter(InitializableRequirement.class::isInstance).forEach(req -> ((InitializableRequirement)req).updateHandler());
        }
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    @Override
    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        this.chatConditions.forEach(step -> step.validateCondition(this.client, chatMessage));
        if (chatMessage.getType() == ChatMessageType.DIALOG) {
            this.dialogConditions.forEach(step -> step.validateCondition(chatMessage.getMessage()));
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        this.npcConditions.forEach(npc -> npc.checkNpcSpawned(event.getNpc()));
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        this.npcConditions.forEach(npc -> npc.checkNpcDespawned(event.getNpc()));
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcCompositionChanged) {
        this.npcConditions.forEach(npc -> npc.checkNpcChanged(npcCompositionChanged));
    }

    protected void updateSteps() {
        Requirement lastPossibleCondition = null;
        for (Requirement conditions : this.steps.keySet()) {
            boolean stepIsLocked = this.steps.get(conditions).isLocked();
            if (conditions != null && conditions.check(this.client) && !stepIsLocked) {
                this.startUpStep(this.steps.get(conditions));
                return;
            }
            if (this.steps.get(conditions).isBlocker() && stepIsLocked) {
                this.startUpStep(this.steps.get(lastPossibleCondition));
                return;
            }
            if (conditions == null || stepIsLocked) continue;
            lastPossibleCondition = conditions;
        }
        if (!this.steps.get(null).isLocked()) {
            this.startUpStep(this.steps.get(null));
        } else {
            this.startUpStep(this.steps.get(lastPossibleCondition));
        }
    }

    protected void startUpStep(QuestStep step) {
        if (this.currentStep == null) {
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
            return;
        }
        if (!step.equals(this.currentStep)) {
            this.shutDownStep();
            this.eventBus.register((Object)step);
            step.startUp();
            this.currentStep = step;
        }
    }

    protected void shutDownStep() {
        if (this.currentStep != null) {
            this.eventBus.unregister((Object)this.currentStep);
            this.currentStep.shutDown();
            this.currentStep = null;
        }
    }

    @Override
    public void makeOverlayHint(PanelComponent panelComponent, QuestHelperPlugin plugin, @NonNull List<String> additionalText, @NonNull List<Requirement> additionalRequirements) {
        if (additionalText == null) {
            throw new NullPointerException("additionalText is marked @NonNull but is null");
        }
        if (additionalRequirements == null) {
            throw new NullPointerException("additionalRequirements is marked @NonNull but is null");
        }
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>(additionalRequirements);
        allRequirements.addAll(this.requirements);
        ArrayList<String> allAdditionalText = new ArrayList<String>(additionalText);
        if (this.text != null) {
            allAdditionalText.addAll(this.text);
        }
        if (this.currentStep != null) {
            this.currentStep.makeOverlayHint(panelComponent, plugin, allAdditionalText, allRequirements);
        }
    }

    @Override
    public void makeWorldOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldArrowOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldArrowOverlayHint(graphics, plugin);
        }
    }

    @Override
    public void makeWorldLineOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        if (this.currentStep != null) {
            this.currentStep.makeWorldLineOverlayHint(graphics, plugin);
        }
    }

    @Override
    public QuestStep getActiveStep() {
        if (this.currentStep != null) {
            return this.currentStep.getActiveStep();
        }
        return this;
    }

    @Override
    public QuestStep getSidePanelStep() {
        if (this.text != null) {
            return this;
        }
        if (this.currentStep != null) {
            return this.currentStep.getSidePanelStep();
        }
        return this;
    }

    public Collection<Requirement> getConditions() {
        return this.steps.keySet();
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return this.steps.values();
    }

    public ConditionalStep copy() {
        ConditionalStep newStep = new ConditionalStep(this.getQuestHelper(), this.steps.get(null), new Requirement[0]);
        if (this.text != null) {
            newStep.setText(this.text);
        }
        this.getConditions().stream().filter(Objects::nonNull).forEach(conditions -> newStep.addStep((Requirement)conditions, this.steps.get(conditions)));
        return newStep;
    }
}

