/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.statemanagement;

import com.questhelper.collections.KeyringCollection;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.runeliteobjects.extendedruneliteobjects.QuestCompletedWidget;
import com.questhelper.statemanagement.AchievementDiaryStepManager;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class GameStateManager {
    @Inject
    Client client;
    @Inject
    ConfigManager configManager;
    @Inject
    QuestCompletedWidget playerQuestCompleteWidget;
    List<KeyringRequirement> keyringKeys;
    WorldPoint lastPlayerPos = null;

    public void startUp() {
        this.keyringKeys = KeyringCollection.allKeyRequirements(this.configManager);
        AchievementDiaryStepManager.setup(this.configManager);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.keyringKeys == null || chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (chatMessage.getMessage().contains("to your key ring.")) {
            for (KeyringRequirement keyringKey : this.keyringKeys) {
                if (!chatMessage.getMessage().contains("You add the " + keyringKey.chatboxText())) continue;
                keyringKey.setConfigValue("true");
            }
        }
        if (chatMessage.getMessage().contains("from your key ring.")) {
            for (KeyringRequirement keyringKey : this.keyringKeys) {
                if (!chatMessage.getMessage().contains("You remove the " + keyringKey.chatboxText())) continue;
                keyringKey.setConfigValue("false");
            }
        }
        if (chatMessage.getMessage().contains("Achievement Diary Stage Task - ")) {
            AchievementDiaryStepManager.check(this.client);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            WorldPoint newPos = player.getWorldLocation();
            if (newPos != null && this.lastPlayerPos != null && newPos.distanceTo(this.lastPlayerPos) != 0) {
                this.playerQuestCompleteWidget.close(this.client);
            }
            this.lastPlayerPos = newPos;
        }
    }
}

