/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.statemanagement;

import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.runelite.RuneliteRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;

@Singleton
public class AchievementDiaryStepManager {
    static Zone workshop;
    static Requirement inWorkshop;
    static RuneliteRequirement killedFire;
    static RuneliteRequirement killedEarth;
    static RuneliteRequirement killedWater;
    static RuneliteRequirement killedAir;

    public static void setup(ConfigManager configManager) {
        AchievementDiaryStepManager.setupKandarin(configManager);
    }

    private static void setupKandarin(ConfigManager configManager) {
        workshop = new Zone(new WorldPoint(2682, 9862, 0), new WorldPoint(2747, 9927, 0));
        inWorkshop = new ZoneRequirement(workshop);
        killedFire = new RuneliteRequirement(configManager, "kandarin-easy-killed-fire", "true");
        killedEarth = new RuneliteRequirement(configManager, "kandarin-easy-killed-earth", "true");
        killedAir = new RuneliteRequirement(configManager, "kandarin-easy-killed-air", "true");
        killedWater = new RuneliteRequirement(configManager, "kandarin-easy-killed-water", "true");
    }

    public static void check(Client client) {
        if (!inWorkshop.check(client)) {
            killedFire.setConfigValue("false");
            killedEarth.setConfigValue("false");
            killedWater.setConfigValue("false");
            killedAir.setConfigValue("false");
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        int id = npc.getId();
        if (id == 1365) {
            killedFire.setConfigValue("true");
        }
        if (id == 1366) {
            killedEarth.setConfigValue("true");
        }
        if (id == 1370) {
            killedWater.setConfigValue("true");
        }
        if (id == 1369) {
            killedAir.setConfigValue("true");
        }
    }

    public static Zone getWorkshop() {
        return workshop;
    }

    public static Requirement getInWorkshop() {
        return inWorkshop;
    }

    public static RuneliteRequirement getKilledFire() {
        return killedFire;
    }

    public static RuneliteRequirement getKilledEarth() {
        return killedEarth;
    }

    public static RuneliteRequirement getKilledWater() {
        return killedWater;
    }

    public static RuneliteRequirement getKilledAir() {
        return killedAir;
    }
}

