/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ChatBox;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ExtendedRuneliteObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ExtendedRuneliteObjects;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeGraphicsObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeItem;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeNpc;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.MenuEntryWrapper;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ReplacedNpc;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectTypes;
import com.questhelper.runeliteobjects.extendedruneliteobjects.WidgetReplacement;
import com.questhelper.steps.WidgetDetails;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RuneliteObjectManager {
    private static final Logger log = LoggerFactory.getLogger(RuneliteObjectManager.class);
    protected final Client client;
    protected final EventBus eventBus;
    protected final ChatboxPanelManager chatboxPanelManager;
    protected final ClientThread clientThread;
    protected final ChatMessageManager chatMessageManager;
    protected final SpriteManager spriteManager;
    protected final Map<String, ExtendedRuneliteObjects> runeliteObjectGroups = new HashMap<String, ExtendedRuneliteObjects>();
    @Inject
    private Hooks hooks;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    Point clickPos;
    int redClickAnimationFrame = 0;
    int bufferRedClickAnimation = 0;
    int[] redClick = new int[]{519, 520, 521, 522};
    final int ANIMATION_PERIOD = 5;
    ExtendedRuneliteObject lastInteractedWithRuneliteObject;
    private static final List<MenuAction> OBJECT_MENU_TYPES = ImmutableList.of((Object)MenuAction.GAME_OBJECT_FIRST_OPTION, (Object)MenuAction.GAME_OBJECT_SECOND_OPTION, (Object)MenuAction.GAME_OBJECT_THIRD_OPTION, (Object)MenuAction.GAME_OBJECT_FOURTH_OPTION, (Object)MenuAction.GAME_OBJECT_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_GAME_OBJECT);
    private static final List<MenuAction> GROUP_ITEM_MENU_TYPES = ImmutableList.of((Object)MenuAction.GROUND_ITEM_FIRST_OPTION, (Object)MenuAction.GROUND_ITEM_SECOND_OPTION, (Object)MenuAction.GROUND_ITEM_THIRD_OPTION, (Object)MenuAction.GROUND_ITEM_FOURTH_OPTION, (Object)MenuAction.GROUND_ITEM_FIFTH_OPTION);
    private LocalPoint locationOfPlayerInteraction;

    @Inject
    public RuneliteObjectManager(Client client, EventBus eventBus, ChatboxPanelManager chatboxPanelManager, ClientThread clientThread, ChatMessageManager chatMessageManager, SpriteManager spriteManager) {
        this.client = client;
        this.eventBus = eventBus;
        this.chatboxPanelManager = chatboxPanelManager;
        this.clientThread = clientThread;
        this.chatMessageManager = chatMessageManager;
        this.spriteManager = spriteManager;
    }

    public void startUp() {
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    public void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        if (this.chatboxPanelManager.getCurrentInput() instanceof ChatBox) {
            this.chatboxPanelManager.close();
        }
        this.clientThread.invokeLater(this::removeRuneliteObjects);
    }

    private void removeRuneliteObjects() {
        this.disableRuneliteObjects();
        this.runeliteObjectGroups.clear();
    }

    private void disableRuneliteObjects() {
        this.runeliteObjectGroups.forEach((groupID, extendedRuneliteObjectGroup) -> extendedRuneliteObjectGroup.disableAll(this));
    }

    public FakeNpc createFakeNpc(String groupID, int[] model, WorldPoint wp, int animation) {
        FakeNpc extendedRuneliteObject = new FakeNpc(this.client, this.clientThread, wp, model, animation, animation);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public FakeNpc createFakeNpc(String groupID, Model model, WorldPoint wp, int animation) {
        FakeNpc extendedRuneliteObject = new FakeNpc(this.client, this.clientThread, wp, model, animation);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public ReplacedNpc createReplacedNpc(int[] model, WorldPoint wp, int npcIDToReplace) {
        String groupID = "global";
        ReplacedNpc extendedRuneliteObject = new ReplacedNpc(this.client, this.clientThread, wp, model, npcIDToReplace);
        for (NPC clientNpc : this.client.getNpcs()) {
            if (clientNpc.getId() != npcIDToReplace) continue;
            extendedRuneliteObject.setNpc(clientNpc);
            break;
        }
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public ReplacedNpc createReplacedNpc(String groupID, int[] model, WorldPoint wp, int npcIDToReplace) {
        ReplacedNpc extendedRuneliteObject = new ReplacedNpc(this.client, this.clientThread, wp, model, npcIDToReplace);
        for (NPC clientNpc : this.client.getNpcs()) {
            if (clientNpc.getId() != npcIDToReplace) continue;
            extendedRuneliteObject.setNpc(clientNpc);
            break;
        }
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public FakeItem createFakeItem(String groupID, int[] model, WorldPoint wp, int animation) {
        FakeItem extendedRuneliteObject = new FakeItem(this.client, this.clientThread, wp, model, animation);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public FakeGraphicsObject createGraphicsFakeObject(String groupID, int[] model, WorldPoint wp, int animation, ExtendedRuneliteObject obj) {
        FakeGraphicsObject extendedRuneliteObject = new FakeGraphicsObject(this.client, this.clientThread, wp, model, animation, obj);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public FakeGraphicsObject createGraphicsFakeObject(String groupID, int[] model, WorldPoint wp, int animation) {
        FakeGraphicsObject extendedRuneliteObject = new FakeGraphicsObject(this.client, this.clientThread, wp, model, animation);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    public FakeObject createFakeObject(String groupID, int[] model, WorldPoint wp, int animation) {
        FakeObject extendedRuneliteObject = new FakeObject(this.client, this.clientThread, wp, model, animation);
        extendedRuneliteObject.activate();
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.get(groupID).addExtendedRuneliteObject(extendedRuneliteObject);
        return extendedRuneliteObject;
    }

    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof NPC) {
            NPC npc = (NPC)renderable;
            for (String groupID : this.runeliteObjectGroups.keySet()) {
                ExtendedRuneliteObjects group = this.runeliteObjectGroups.get(groupID);
                for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                    boolean passesRequirementToShowReplacement;
                    ReplacedNpc replacedNpc;
                    if (!(extendedRuneliteObject instanceof ReplacedNpc) || (replacedNpc = (ReplacedNpc)extendedRuneliteObject).getNpc() != npc) continue;
                    Point p = this.client.getMouseCanvasPosition();
                    boolean bl = passesRequirementToShowReplacement = replacedNpc.getDisplayReq() == null || replacedNpc.getDisplayReq().check(this.client);
                    if (!passesRequirementToShowReplacement) {
                        return true;
                    }
                    if (!replacedNpc.getEntries().isEmpty()) {
                        return false;
                    }
                    return replacedNpc.getClickbox() == null || replacedNpc.getClickbox().contains(p.getX(), p.getY());
                }
            }
        }
        return true;
    }

    public ExtendedRuneliteObjects addSubGroup(String groupID, String subGroupID) {
        this.runeliteObjectGroups.computeIfAbsent(groupID, existingVal -> new ExtendedRuneliteObjects(groupID));
        this.runeliteObjectGroups.computeIfAbsent(subGroupID, existingVal -> new ExtendedRuneliteObjects(subGroupID));
        ExtendedRuneliteObjects subgroup = this.runeliteObjectGroups.get(subGroupID);
        this.runeliteObjectGroups.get(groupID).addSubGroup(subgroup);
        return subgroup;
    }

    public void removeGroupAndSubgroups(String groupID) {
        if (this.runeliteObjectGroups.get(groupID) == null) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (this.runeliteObjectGroups.get(groupID) == null) {
                return;
            }
            this.runeliteObjectGroups.get(groupID).removeAllIncludingSubgroups(this);
        });
    }

    public void removeRuneliteObject(String groupID, ExtendedRuneliteObject eRuneliteObject) {
        if (eRuneliteObject == null) {
            throw new IllegalStateException("Attempted to remove null RuneliteObject from Manager");
        }
        eRuneliteObject.disable();
        ExtendedRuneliteObjects groupERuneliteObjects = this.runeliteObjectGroups.get(groupID);
        if (groupERuneliteObjects == null) {
            throw new IllegalStateException("Attempted to remove non-added ExtendedRuneliteObjects " + groupID + "from Manager");
        }
        groupERuneliteObjects.remove(eRuneliteObject);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        NPC npc = event.getMenuEntry().getNpc();
        if (npc != null) {
            for (String groupID2 : this.runeliteObjectGroups.keySet()) {
                ExtendedRuneliteObjects group = this.runeliteObjectGroups.get(groupID2);
                for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                    this.copyMenuEntry(extendedRuneliteObject, event, npc);
                }
            }
        }
        ArrayList objs = new ArrayList();
        this.runeliteObjectGroups.forEach((groupID, runeliteObjectGroup) -> objs.addAll(runeliteObjectGroup.extendedRuneliteObjects));
        for (ExtendedRuneliteObject obj : objs) {
            this.setupMenuOptions(obj, event);
        }
    }

    private void copyMenuEntry(ExtendedRuneliteObject extendedRuneliteObject, MenuEntryAdded event, NPC npc) {
        ReplacedNpc replacedNpc;
        if (extendedRuneliteObject instanceof ReplacedNpc && (replacedNpc = (ReplacedNpc)extendedRuneliteObject).getNpc() == npc) {
            boolean shouldSkip = false;
            for (MenuEntryWrapper entry : replacedNpc.getEntries()) {
                if (entry.option.equals(event.getOption())) {
                    shouldSkip = true;
                    break;
                }
                if (!event.getOption().equals("Examine")) continue;
                shouldSkip = true;
                break;
            }
            if (shouldSkip) {
                return;
            }
            replacedNpc.addMenuEntry(new MenuEntryWrapper(event.getOption(), event.getMenuEntry().getType(), event.getTarget(), event.getIdentifier(), 0, 0));
        }
    }

    private void setupMenuOptions(ExtendedRuneliteObject extendedRuneliteObject, MenuEntryAdded event) {
        if (!extendedRuneliteObject.isRuneliteObjectActive()) {
            return;
        }
        if (extendedRuneliteObject.getMenuActions().isEmpty() && !(extendedRuneliteObject instanceof ReplacedNpc)) {
            return;
        }
        LocalPoint lp = extendedRuneliteObject.getRuneliteObject().getLocation();
        int widgetIndex = event.getActionParam0();
        int widgetID = event.getActionParam1();
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (!extendedRuneliteObject.isHiddenNoOptions() && extendedRuneliteObject.getRuneliteObject() != null && extendedRuneliteObject.getRuneliteObject().getModel() != null) {
            Actor actor;
            if (!this.isMouseOverObject(extendedRuneliteObject)) {
                return;
            }
            if (event.getOption().equals("Walk here") && this.isMouseOverObject(extendedRuneliteObject)) {
                if (extendedRuneliteObject instanceof ReplacedNpc) {
                    this.addReplacedNpcOptions(extendedRuneliteObject, event);
                }
                extendedRuneliteObject.getMenuActions().forEach((name, action) -> this.addAction(extendedRuneliteObject, widgetIndex, widgetID, (String)name));
                extendedRuneliteObject.getPriorityMenuActions().forEach((name, action) -> this.addPriorityAction(extendedRuneliteObject, widgetIndex, widgetID, (String)name));
                if (extendedRuneliteObject.getReplaceWalkAction() != null && extendedRuneliteObject.getReplaceWalkActionText() != null) {
                    this.addReplaceWalkAction(event.getMenuEntry(), extendedRuneliteObject);
                }
            }
            if (lp == null) {
                return;
            }
            boolean isHighPriorityOnTile = false;
            for (MenuEntry menuEntry : menuEntries) {
                if (menuEntry.getType() != MenuAction.RUNELITE_HIGH_PRIORITY) continue;
                isHighPriorityOnTile = true;
            }
            if (!isHighPriorityOnTile) {
                return;
            }
            if (OBJECT_MENU_TYPES.contains(event.getMenuEntry().getType())) {
                this.updatePriorities(event, event.getActionParam0(), event.getActionParam1(), menuEntries, lp, false);
            }
            if (GROUP_ITEM_MENU_TYPES.contains(event.getMenuEntry().getType())) {
                this.updatePriorities(event, event.getActionParam0(), event.getActionParam1(), menuEntries, lp, true);
            }
            if ((actor = event.getMenuEntry().getActor()) != null) {
                LocalPoint actorLp = actor.getLocalLocation();
                this.updatePriorities(event, actorLp.getSceneX(), actorLp.getSceneY(), menuEntries, lp, false);
            }
        }
    }

    private void addReplacedNpcOptions(ExtendedRuneliteObject extendedRuneliteObject, MenuEntryAdded event) {
        ReplacedNpc replacedNpc = (ReplacedNpc)extendedRuneliteObject;
        if (!replacedNpc.getEntries().isEmpty()) {
            for (MenuEntryWrapper entry : replacedNpc.getEntries()) {
                this.client.createMenuEntry(-1).setOption(entry.getOption()).setType(entry.getType()).setTarget("<col=" + replacedNpc.getNameColor() + ">" + replacedNpc.getName() + "</col>").setIdentifier(entry.getIdentifier()).setParam0(0).setParam1(0).setParent(event.getMenuEntry().getParent());
            }
        }
    }

    public void disableObject(ExtendedRuneliteObject extendedRuneliteObject) {
        extendedRuneliteObject.disable();
    }

    public void removeGroup(String groupID) {
        if (this.runeliteObjectGroups.get(groupID) == null) {
            return;
        }
        this.runeliteObjectGroups.get(groupID).removeAll(this);
        this.runeliteObjectGroups.remove(groupID);
    }

    private void updatePriorities(MenuEntryAdded event, int currentItemX, int currentItemY, MenuEntry[] menuEntries, LocalPoint runeliteObjectLp, boolean shouldPrioritizeObject) {
        int cameraX = this.client.getCameraX();
        int cameraY = this.client.getCameraY();
        int playerX = this.client.getLocalPlayer().getLocalLocation().getX();
        int playerY = this.client.getLocalPlayer().getLocalLocation().getY();
        int shiftToBeEqualOr = 0;
        if (shouldPrioritizeObject) {
            shiftToBeEqualOr = 1;
        }
        if (cameraX - playerX + 15 > 0 && currentItemX < runeliteObjectLp.getSceneX() + shiftToBeEqualOr || cameraX - playerX + 15 < 0 && currentItemX > runeliteObjectLp.getSceneX() - shiftToBeEqualOr || cameraY - playerY - 15 > 0 && currentItemY < runeliteObjectLp.getSceneY() + shiftToBeEqualOr || cameraY - playerY - 15 < 0 && currentItemY > runeliteObjectLp.getSceneY() - shiftToBeEqualOr) {
            event.getMenuEntry().setDeprioritized(true);
            for (MenuEntry menuEntry : menuEntries) {
                if (menuEntry.getType() != MenuAction.RUNELITE_HIGH_PRIORITY) continue;
                menuEntry.setDeprioritized(false);
            }
        }
    }

    public void createChatboxMessage(String text) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(text).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.NPC_EXAMINE).runeLiteFormattedMessage(chatMessage).timestamp((int)(System.currentTimeMillis() / 1000L)).build());
    }

    public Consumer<MenuEntry> getExamineAction(ExtendedRuneliteObject extendedRuneliteObject) {
        return menuEntry -> this.createChatboxMessage(extendedRuneliteObject.getExamine());
    }

    public Consumer<MenuEntry> getTalkAction(ExtendedRuneliteObject extendedRuneliteObject) {
        return menuEntry -> {
            WorldPoint wp = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation());
            if (extendedRuneliteObject.isNeedToBeCloseToTalk() && wp.distanceTo(extendedRuneliteObject.getWorldPoint()) > 3) {
                this.createChatboxMessage("You'll need to move closer to them to talk!");
                return;
            }
            this.locationOfPlayerInteraction = this.client.getLocalPlayer().getLocalLocation();
            extendedRuneliteObject.setOrientationGoalAsPlayer(this.client);
            extendedRuneliteObject.setupChatBox(this.chatboxPanelManager);
        };
    }

    private void addReplaceWalkAction(MenuEntry menuEntry, ExtendedRuneliteObject extendedRuneliteObject) {
        menuEntry.setOption(extendedRuneliteObject.getReplaceWalkActionText());
        menuEntry.setTarget("<col=" + extendedRuneliteObject.getNameColor() + ">" + extendedRuneliteObject.getName() + "</col>");
        menuEntry.onClick(menuEnt -> {
            this.resetRedClick();
            this.lastInteractedWithRuneliteObject = extendedRuneliteObject;
            extendedRuneliteObject.getReplaceWalkAction().accept((MenuEntry)menuEnt);
        });
    }

    private void addPriorityAction(ExtendedRuneliteObject extendedRuneliteObject, int widgetIndex, int widgetID, String actionWord) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
        this.client.createMenuEntry(-2).setOption(actionWord).setTarget("<col=" + extendedRuneliteObject.getNameColor() + ">" + extendedRuneliteObject.getName() + "</col>").setType(MenuAction.RUNELITE_HIGH_PRIORITY).setDeprioritized(false).onClick(menuEntry -> {
            this.resetRedClick();
            this.lastInteractedWithRuneliteObject = extendedRuneliteObject;
            extendedRuneliteObject.activatePriorityAction(actionWord, (MenuEntry)menuEntry);
        }).setParam0(widgetIndex).setParam1(widgetID);
    }

    private void addAction(ExtendedRuneliteObject extendedRuneliteObject, int widgetIndex, int widgetID, String actionWord) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        menuEntries = Arrays.copyOf(menuEntries, menuEntries.length + 1);
        this.client.createMenuEntry(menuEntries.length - 1).setOption(actionWord).setTarget("<col=" + extendedRuneliteObject.getNameColor() + ">" + extendedRuneliteObject.getName() + "</col>").setType(MenuAction.RUNELITE).onClick(menuEntry -> {
            this.resetRedClick();
            extendedRuneliteObject.activateAction(actionWord, (MenuEntry)menuEntry);
        }).setParam0(widgetIndex).setParam1(widgetID);
    }

    private void resetRedClick() {
        this.clickPos = this.client.getMouseCanvasPosition();
        this.redClickAnimationFrame = 0;
        this.bufferRedClickAnimation = 0;
    }

    private boolean isMouseOverObject(ExtendedRuneliteObject extendedRuneliteObject) {
        Shape clickbox = extendedRuneliteObject.getClickbox();
        if (clickbox == null) {
            return false;
        }
        Point p = this.client.getMouseCanvasPosition();
        return clickbox.contains(p.getX(), p.getY());
    }

    public void makeWidgetOverlayHint(Graphics2D graphics) {
        this.renderRedClick(graphics);
        if (this.lastInteractedWithRuneliteObject != null && this.locationOfPlayerInteraction != null && this.client.getLocalPlayer().getLocalLocation().distanceTo(this.locationOfPlayerInteraction) > 0 && this.chatboxPanelManager.getCurrentInput() instanceof ChatBox) {
            this.chatboxPanelManager.close();
        }
    }

    public void makeWorldOverlayHint(Graphics2D graphics) {
        this.runeliteObjectGroups.forEach((groupID, group) -> {
            for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                if (!extendedRuneliteObject.isRuneliteObjectActive() || extendedRuneliteObject.getOverheadText() == null) continue;
                this.checkToAddOverheadText(extendedRuneliteObject, graphics);
            }
        });
    }

    private void checkToAddOverheadText(ExtendedRuneliteObject extendedRuneliteObject, Graphics2D graphics) {
        if (extendedRuneliteObject.getTickToRemoveOverheadText() <= this.client.getTickCount()) {
            extendedRuneliteObject.clearOverheadText();
            return;
        }
        this.addOverheadText(extendedRuneliteObject, graphics);
    }

    private void addOverheadText(ExtendedRuneliteObject rlObj, Graphics2D graphics) {
        Point p;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)rlObj.getWorldPoint());
        if (lp != null && (p = Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)this.client.getPlane(), (int)rlObj.getRuneliteObject().getModelHeight())) != null) {
            Font overheadFont = FontManager.getRunescapeBoldFont();
            FontMetrics metrics = graphics.getFontMetrics(overheadFont);
            Point shiftedP = new Point(p.getX() - metrics.stringWidth(rlObj.getOverheadText()) / 2, p.getY());
            graphics.setFont(overheadFont);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)shiftedP, (String)rlObj.getOverheadText(), (Color)JagexColors.YELLOW_INTERFACE_TEXT);
        }
    }

    private void renderRedClick(Graphics2D graphics) {
        if (this.clickPos != null && this.redClickAnimationFrame < 4) {
            BufferedImage img = this.spriteManager.getSprite(this.redClick[this.redClickAnimationFrame], 0);
            if (img == null) {
                return;
            }
            Point point = new Point(this.clickPos.getX() - img.getWidth() / 2, this.clickPos.getY() - img.getHeight() / 2);
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)point, (BufferedImage)img);
        } else {
            this.clickPos = null;
            this.redClickAnimationFrame = 0;
        }
    }

    private boolean isNpcOnTile(ExtendedRuneliteObject extendedRuneliteObject) {
        for (NPC npc : this.client.getNpcs()) {
            WorldPoint wpNpc = npc.getWorldLocation();
            WorldPoint rlObjWp = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)extendedRuneliteObject.getRuneliteObject().getLocation());
            if (wpNpc == null || wpNpc.distanceTo(rlObjWp) != 0 || extendedRuneliteObject instanceof ReplacedNpc && npc == ((ReplacedNpc)extendedRuneliteObject).getNpc()) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerOnTile(ExtendedRuneliteObject extendedRuneliteObject, WorldPoint playerPosition) {
        WorldPoint rlObjWp = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)extendedRuneliteObject.getRuneliteObject().getLocation());
        return playerPosition.distanceTo(rlObjWp) == 0;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        this.runeliteObjectGroups.forEach((groupID, group) -> {
            for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                if (!(extendedRuneliteObject instanceof ReplacedNpc)) continue;
                ReplacedNpc replacedNpc = (ReplacedNpc)extendedRuneliteObject;
                if (event.getNpc().getId() != replacedNpc.getNpcIDToReplace()) continue;
                replacedNpc.setNpc(event.getNpc());
            }
        });
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        this.runeliteObjectGroups.forEach((groupID, group) -> {
            for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                if (!(extendedRuneliteObject instanceof ReplacedNpc)) continue;
                ReplacedNpc replacedNpc = (ReplacedNpc)extendedRuneliteObject;
                if (event.getNpc().getId() != replacedNpc.getNpcIDToReplace()) continue;
                replacedNpc.setNpc(null);
            }
        });
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        ArrayList groups = new ArrayList();
        this.runeliteObjectGroups.forEach((groupID, extendedRuneliteObjectsGroup) -> groups.add(extendedRuneliteObjectsGroup));
        for (ExtendedRuneliteObjects group : groups) {
            for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                if (extendedRuneliteObject.getDisableAfterTick() != -1 && extendedRuneliteObject.getDisableAfterTick() <= this.client.getTickCount()) {
                    this.disableObject(extendedRuneliteObject);
                    extendedRuneliteObject.setDisableAfterTick(-1);
                }
                if (!extendedRuneliteObject.isRuneliteObjectActive()) continue;
                extendedRuneliteObject.actionOnGameTick();
                if (this.client.getPlane() != extendedRuneliteObject.getWorldPoint().getPlane()) {
                    this.disableObject(extendedRuneliteObject);
                }
                if (!extendedRuneliteObject.isHiddenNoOptions()) continue;
                this.disableObject(extendedRuneliteObject);
            }
        }
        if (this.lastInteractedWithRuneliteObject != null) {
            this.lastInteractedWithRuneliteObject.checkPendingAction();
            if (this.lastInteractedWithRuneliteObject.getMenuActions().get("Talk-to") != null || this.lastInteractedWithRuneliteObject.getPriorityMenuActions().get("Talk-to") != null) {
                this.lastInteractedWithRuneliteObject.progressDialog();
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        this.bufferRedClickAnimation = Math.floorMod(this.bufferRedClickAnimation + 1, 5);
        if (this.bufferRedClickAnimation == 0) {
            ++this.redClickAnimationFrame;
        }
        WorldPoint playerPosition = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation());
        this.runeliteObjectGroups.forEach((groupID, extendedRuneliteObjectGroup) -> {
            for (ExtendedRuneliteObject extendedRuneliteObject : extendedRuneliteObjectGroup.extendedRuneliteObjects) {
                boolean shouldDisplayReqPassed;
                ReplacedNpc replacedNpc;
                NPC npc;
                extendedRuneliteObject.actionOnClientTick();
                if (extendedRuneliteObject instanceof ReplacedNpc && (npc = (replacedNpc = (ReplacedNpc)extendedRuneliteObject).getNpc()) != null) {
                    replacedNpc.updateNpcSync(this.client);
                }
                if (extendedRuneliteObject.getOrientationGoal() != extendedRuneliteObject.getRuneliteObject().getOrientation()) {
                    extendedRuneliteObject.partiallyRotateToGoal();
                }
                boolean isVisible = extendedRuneliteObject.isVisible();
                boolean bl = shouldDisplayReqPassed = extendedRuneliteObject.getDisplayReq() == null || extendedRuneliteObject.getDisplayReq().check(this.client);
                if (extendedRuneliteObject.objectType == RuneliteObjectTypes.NPC && (!shouldDisplayReqPassed || this.isNpcOnTile(extendedRuneliteObject) || this.isPlayerOnTile(extendedRuneliteObject, playerPosition))) {
                    if (!isVisible) continue;
                    extendedRuneliteObject.setVisible(false);
                    continue;
                }
                extendedRuneliteObject.setVisible(true);
            }
        });
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.runeliteObjectGroups.forEach((groupID, group) -> {
            for (ExtendedRuneliteObject extendedRuneliteObject : group.extendedRuneliteObjects) {
                if (!(extendedRuneliteObject instanceof ReplacedNpc)) continue;
                this.clientThread.invokeLater(() -> this.replaceWidgetsForReplacedNpcs((ReplacedNpc)extendedRuneliteObject, event));
            }
        });
    }

    public void replaceWidgetsForReplacedNpcs(ReplacedNpc object, WidgetLoaded event) {
        if (object.getDisplayReq() != null && !object.getDisplayReq().check(this.client)) {
            return;
        }
        for (WidgetReplacement widgetReplacement : object.getWidgetReplacements()) {
            Widget widget;
            WidgetDetails widgetDetails = widgetReplacement.getWidgetDetails();
            if (event.getGroupId() != widgetDetails.getGroupID() || (widget = this.client.getWidget(widgetDetails.getGroupID(), widgetDetails.getChildID())) == null || widgetDetails.getChildChildID() != -1 && (widget = widget.getChild(widgetDetails.getChildChildID())) == null) continue;
            widget.setText(widget.getText().replace(widgetReplacement.getTextToReplace(), widgetReplacement.getReplacementText()));
            widget.revalidate();
        }
        if (event.getGroupId() == 231) {
            Widget npcChatName = this.client.getWidget(15138820);
            Widget npcChatHead = this.client.getWidget(15138818);
            this.clientThread.invokeLater(() -> {
                if (npcChatHead == null || npcChatName == null) {
                    return;
                }
                NPCComposition comp = this.client.getNpcDefinition(object.getNpcIDToReplace());
                if (npcChatName.getText().equals(comp.getName())) {
                    npcChatName.setText(object.getName());
                }
                if (npcChatHead.getModelId() == object.getNpcIDToReplace() && object.getFace() != -1) {
                    npcChatHead.setModelId(object.getFace());
                }
            });
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.runeliteObjectGroups.forEach((groupID, extendedRuneliteObjectGroup) -> {
                for (ExtendedRuneliteObject extendedRuneliteObject : extendedRuneliteObjectGroup.extendedRuneliteObjects) {
                    extendedRuneliteObject.render();
                }
            });
        } else if (event.getGameState() == GameState.LOADING) {
            this.runeliteObjectGroups.forEach((groupID, extendedRuneliteObjectGroup) -> {
                for (ExtendedRuneliteObject extendedRuneliteObject : extendedRuneliteObjectGroup.extendedRuneliteObjects) {
                    extendedRuneliteObject.render();
                }
            });
        }
    }
}

