/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.questhelper.runeliteobjects.extendedruneliteobjects.FakeNpc;
import com.questhelper.runeliteobjects.extendedruneliteobjects.MenuEntryWrapper;
import com.questhelper.runeliteobjects.extendedruneliteobjects.WidgetReplacement;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;

public class ReplacedNpc
extends FakeNpc {
    private NPC npc;
    private int npcIDToReplace;
    private final ArrayList<MenuEntryWrapper> entries = new ArrayList();
    private final List<WidgetReplacement> widgetReplacements = new ArrayList<WidgetReplacement>();

    protected ReplacedNpc(Client client, ClientThread clientThread, WorldPoint worldPoint, int[] model, int npcIDToReplace) {
        super(client, clientThread, worldPoint, model, 808);
        this.npcIDToReplace = npcIDToReplace;
    }

    public void updateNpcSync(Client client) {
        if (this.npc.getAnimation() != -1) {
            this.setAnimation(this.npc.getAnimation());
        } else if (this.npc.getLocalLocation().distanceTo(this.getRuneliteObject().getLocation()) == 0) {
            this.setAnimation(this.npc.getIdlePoseAnimation());
        } else {
            this.setAnimation(this.npc.getWalkAnimation());
        }
        this.getRuneliteObject().setLocation(this.npc.getLocalLocation(), client.getPlane());
        this.setOrientationGoal(this.npc.getOrientation());
        if (!this.isRuneliteObjectActive()) {
            this.activate();
        }
    }

    public void addWidgetReplacement(WidgetReplacement widgetReplacement) {
        this.widgetReplacements.add(widgetReplacement);
    }

    public void addMenuEntry(MenuEntryWrapper menuEntry) {
        this.entries.add(menuEntry);
    }

    @Override
    public Shape getClickbox() {
        if (this.npc == null) {
            return null;
        }
        return Perspective.getClickbox((Client)this.client, (Model)this.npc.getModel(), (int)this.npc.getOrientation(), (int)this.npc.getLocalLocation().getX(), (int)this.npc.getLocalLocation().getY(), (int)Perspective.getTileHeight((Client)this.client, (LocalPoint)this.npc.getLocalLocation(), (int)this.getWorldPoint().getPlane()));
    }

    @Override
    public void updateLocation(LocalPoint lp) {
    }

    public NPC getNpc() {
        return this.npc;
    }

    public void setNpc(NPC npc) {
        this.npc = npc;
    }

    public int getNpcIDToReplace() {
        return this.npcIDToReplace;
    }

    public void setNpcIDToReplace(int npcIDToReplace) {
        this.npcIDToReplace = npcIDToReplace;
    }

    public ArrayList<MenuEntryWrapper> getEntries() {
        return this.entries;
    }

    public List<WidgetReplacement> getWidgetReplacements() {
        return this.widgetReplacements;
    }
}

