/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.questhelper.runeliteobjects.extendedruneliteobjects.ExtendedRuneliteObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectTypes;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;

public class FakeNpc
extends ExtendedRuneliteObject {
    int idleAnimation;
    Integer secondAnimation;
    boolean alwaysFacePlayer;

    protected FakeNpc(Client client, ClientThread clientThread, WorldPoint worldPoint, int[] model, int animation) {
        super(client, clientThread, worldPoint, model, animation);
        this.objectType = RuneliteObjectTypes.NPC;
    }

    protected FakeNpc(Client client, ClientThread clientThread, WorldPoint worldPoint, Model model, int animation) {
        super(client, clientThread, worldPoint, model, animation);
        this.idleAnimation = animation;
        this.objectType = RuneliteObjectTypes.NPC;
    }

    protected FakeNpc(Client client, ClientThread clientThread, WorldPoint worldPoint, int[] model, int animation, int idleAnimation) {
        super(client, clientThread, worldPoint, model, animation);
        this.objectType = RuneliteObjectTypes.NPC;
        this.idleAnimation = idleAnimation;
    }

    public void setAnimation(int animation, int secondAnimation) {
        if (this.animation == animation) {
            return;
        }
        this.animation = animation;
        this.secondAnimation = secondAnimation;
        this.update();
    }

    @Override
    protected void update() {
        this.clientThread.invoke(() -> {
            this.runeliteObject.setAnimation(this.client.loadAnimation(this.animation));
            this.runeliteObject.setModel(this.model);
            this.runeliteObject.setShouldLoop(true);
            return true;
        });
    }

    @Override
    protected void actionOnClientTick() {
        super.actionOnClientTick();
        if (this.animation != this.idleAnimation && this.runeliteObject.getAnimation().getNumFrames() <= this.runeliteObject.getAnimationFrame() + 1) {
            if (this.secondAnimation != null) {
                this.setAnimation(this.secondAnimation);
                this.secondAnimation = null;
            } else {
                this.setAnimation(this.idleAnimation);
            }
        }
        if (this.alwaysFacePlayer) {
            this.setOrientationGoalAsPlayer(this.client);
        }
    }

    public void setIdleAnimation(int idleAnimation) {
        this.idleAnimation = idleAnimation;
    }

    public void setAlwaysFacePlayer(boolean alwaysFacePlayer) {
        this.alwaysFacePlayer = alwaysFacePlayer;
    }
}

