/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.questhelper.runeliteobjects.extendedruneliteobjects.ExtendedRuneliteObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import java.util.ArrayList;
import java.util.List;

public class ExtendedRuneliteObjects {
    private final String groupName;
    List<ExtendedRuneliteObject> extendedRuneliteObjects = new ArrayList<ExtendedRuneliteObject>();
    List<ExtendedRuneliteObjects> subGroups = new ArrayList<ExtendedRuneliteObjects>();

    public ExtendedRuneliteObjects(String groupName) {
        this.groupName = groupName;
    }

    public ExtendedRuneliteObjects(String groupName, ExtendedRuneliteObject npc) {
        this.groupName = groupName;
        this.extendedRuneliteObjects.add(npc);
    }

    public ExtendedRuneliteObjects(String groupName, List<ExtendedRuneliteObject> extendedRuneliteObjects) {
        this.groupName = groupName;
        this.extendedRuneliteObjects.addAll(extendedRuneliteObjects);
    }

    public void addExtendedRuneliteObject(ExtendedRuneliteObject npc) {
        this.extendedRuneliteObjects.add(npc);
    }

    public void addSubGroup(ExtendedRuneliteObjects subgroup) {
        this.subGroups.add(subgroup);
    }

    public void remove(ExtendedRuneliteObject npc) {
        this.extendedRuneliteObjects.remove(npc);
    }

    public void removeAll(RuneliteObjectManager runeliteObjectManager) {
        this.disableAll(runeliteObjectManager);
        this.extendedRuneliteObjects.clear();
    }

    public void disableAll(RuneliteObjectManager runeliteObjectManager) {
        for (ExtendedRuneliteObject npc : this.extendedRuneliteObjects) {
            npc.disable();
        }
    }

    public void disableAllIncludingSubgroups(RuneliteObjectManager runeliteObjectManager) {
        this.disableAll(runeliteObjectManager);
        for (ExtendedRuneliteObjects subGroup : this.subGroups) {
            runeliteObjectManager.removeGroup(subGroup.getGroupName());
        }
    }

    public void removeAllIncludingSubgroups(RuneliteObjectManager runeliteObjectManager) {
        this.disableAllIncludingSubgroups(runeliteObjectManager);
        for (ExtendedRuneliteObjects subGroup : this.subGroups) {
            runeliteObjectManager.removeGroupAndSubgroups(subGroup.getGroupName());
        }
        this.extendedRuneliteObjects.clear();
        this.subGroups.clear();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<ExtendedRuneliteObject> getExtendedRuneliteObjects() {
        return this.extendedRuneliteObjects;
    }
}

