/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.questhelper.requirements.Requirement;
import com.questhelper.runeliteobjects.RuneliteConfigSetter;
import com.questhelper.runeliteobjects.dialog.RuneliteDialogStep;
import com.questhelper.runeliteobjects.dialog.RuneliteObjectDialogStep;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ChatBox;
import com.questhelper.runeliteobjects.extendedruneliteobjects.FaceAnimationIDs;
import com.questhelper.runeliteobjects.extendedruneliteobjects.NpcChatBox;
import com.questhelper.runeliteobjects.extendedruneliteobjects.PlayerChatBox;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ReplacedObject;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectTypes;
import com.questhelper.runeliteobjects.extendedruneliteobjects.actions.Action;
import com.questhelper.runeliteobjects.extendedruneliteobjects.actions.LoopedAction;
import com.questhelper.steps.tools.QuestPerspective;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.MenuEntry;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Perspective;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.chatbox.ChatboxPanelManager;

public class ExtendedRuneliteObject {
    protected final RuneLiteObject runeliteObject;
    protected final Client client;
    protected final ClientThread clientThread;
    private final LinkedHashMap<Requirement, RuneliteDialogStep> dialogTrees = new LinkedHashMap();
    protected Model model;
    protected int animation;
    private WorldPoint worldPoint;
    private int face = -1;
    private String name = "Test";
    private String examine;
    private Requirement displayReq;
    private String overheadText;
    private int tickToRemoveOverheadText;
    ChatBox currentChatBox;
    private ReplacedObject objectToRemove;
    private Consumer<MenuEntry> replaceWalkAction;
    private String replaceWalkActionText;
    private final Map<String, Action> menuActions = new HashMap<String, Action>();
    private final Map<String, Action> priorityMenuActions = new HashMap<String, Action>();
    private LoopedAction activeLoopedAction;
    private Map<Action, Integer> delayedActions = new HashMap<Action, Integer>();
    protected RuneliteObjectTypes objectType = RuneliteObjectTypes.UNDEFINED;
    protected String nameColor = "ffff00";
    private boolean isHiddenNoOptions;
    private int orientationGoal;
    public static final int MAX_TALK_DISTANCE = 3;
    private boolean visible = true;
    int lastActionPerformedAt;
    boolean wasActiveLastTick = false;
    private boolean needToBeCloseToTalk = true;
    private int disableAfterTick = -1;
    private boolean active = true;
    private Supplier<Boolean> pendingAction;

    protected ExtendedRuneliteObject(Client client, ClientThread clientThread, WorldPoint worldPoint, Model model, int animation) {
        this.client = client;
        this.clientThread = clientThread;
        this.runeliteObject = client.createRuneLiteObject();
        this.model = model;
        this.animation = animation;
        this.update();
        this.runeliteObject.setShouldLoop(true);
        this.worldPoint = worldPoint;
        LocalPoint lp = QuestPerspective.getInstanceLocalPointFromReal(client, worldPoint);
        if (lp == null) {
            return;
        }
        this.runeliteObject.setLocation(lp, client.getPlane());
        this.activate();
    }

    protected ExtendedRuneliteObject(Client client, ClientThread clientThread, WorldPoint worldPoint, int[] model, int animation) {
        this(client, clientThread, worldPoint, ExtendedRuneliteObject.createModel(client, model).cloneColors().light(), animation);
    }

    private static ModelData createModel(Client client, int[] data) {
        ModelData[] modelData = new ModelData[data.length];
        for (int i = 0; i < data.length; ++i) {
            modelData[i] = client.loadModelData(data[i]);
        }
        return client.mergeModels(modelData);
    }

    private static ModelData createModel(Client client, ModelData[] data) {
        return client.mergeModels(data);
    }

    public Shape getClickbox() {
        if (QuestPerspective.getInstanceLocalPointFromReal(this.client, this.worldPoint) == null) {
            return null;
        }
        return Perspective.getClickbox((Client)this.client, (Model)this.getRuneliteObject().getModel(), (int)this.getRuneliteObject().getOrientation(), (int)this.getRuneliteObject().getLocation().getX(), (int)this.getRuneliteObject().getLocation().getY(), (int)Perspective.getTileHeight((Client)this.client, (LocalPoint)this.getRuneliteObject().getLocation(), (int)this.client.getPlane()));
    }

    public void setAnimation(int animation) {
        if (this.animation == animation) {
            return;
        }
        this.animation = animation;
        this.update();
    }

    public void setModel(int[] model) {
        this.model = ExtendedRuneliteObject.createModel(this.client, model).cloneColors().light();
        this.update();
    }

    public void setWorldPoint(WorldPoint worldPoint) {
        this.worldPoint = worldPoint;
        LocalPoint lp = QuestPerspective.getInstanceLocalPointFromReal(this.client, worldPoint);
        if (lp == null) {
            return;
        }
        this.runeliteObject.setLocation(lp, this.client.getPlane());
    }

    public void setScaledModel(int[] model, int xScale, int yScale, int zScale) {
        this.model = ((ModelData)ExtendedRuneliteObject.createModel(this.client, model).cloneColors().cloneVertices().scale(xScale, yScale, zScale)).light();
        this.update();
    }

    protected void update() {
        this.clientThread.invoke(() -> {
            this.runeliteObject.setAnimation(this.client.loadAnimation(this.animation));
            this.runeliteObject.setModel(this.model);
            return true;
        });
    }

    public boolean isRuneliteObjectActive() {
        return this.runeliteObject.isActive();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.render();
    }

    public void render() {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.getWorldPoint());
        if (lp == null || !this.active) {
            this.isHiddenNoOptions = true;
            this.runeliteObject.setActive(false);
            return;
        }
        this.updateLocation(lp);
        if ((this.displayReq == null || this.displayReq.check(this.client)) && this.visible) {
            if (this.objectToRemove != null) {
                this.removeOtherObjects();
            }
            this.isHiddenNoOptions = false;
            this.runeliteObject.setActive(true);
        } else {
            this.isHiddenNoOptions = true;
            this.delayedActions.clear();
            this.runeliteObject.setActive(false);
        }
    }

    public void updateLocation(LocalPoint lp) {
        this.runeliteObject.setLocation(lp, this.getWorldPoint().getPlane());
    }

    public void activate() {
        this.active = true;
        this.visible = true;
        this.render();
    }

    public void disable() {
        this.active = false;
        this.visible = false;
        if (this.objectToRemove != null) {
            // empty if block
        }
        this.render();
    }

    public void setObjectToRemove(ReplacedObject replacedObject) {
        this.objectToRemove = replacedObject;
        if (this.isRuneliteObjectActive()) {
            this.removeOtherObjects();
        }
    }

    protected void actionOnClientTick() {
    }

    protected void actionOnGameTick() {
        WorldPoint playerPoint;
        ArrayList actionsToPerform = new ArrayList();
        this.delayedActions.forEach((action, tickToPerform) -> {
            if (this.client.getTickCount() >= tickToPerform) {
                actionsToPerform.add(action);
            }
        });
        for (Action action2 : actionsToPerform) {
            this.delayedActions.remove(action2);
            action2.activate(action2.getMenuEntry());
        }
        if (!this.wasActiveLastTick && this.activeLoopedAction != null) {
            this.wasActiveLastTick = true;
            this.lastActionPerformedAt = this.client.getTickCount();
        }
        if ((playerPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation())).distanceTo(this.worldPoint) > 30) {
            this.disableActiveLoopedAction();
        } else if (this.activeLoopedAction != null && this.activeLoopedAction.getTicksBetweenActions().get() <= this.client.getTickCount() - this.lastActionPerformedAt) {
            this.activeLoopedAction.activate(this.activeLoopedAction.getMenuEntry());
            this.lastActionPerformedAt = this.client.getTickCount();
        }
    }

    public void addDelayedAction(int delayInTicks, Action action) {
        this.delayedActions.put(action, this.client.getTickCount() + delayInTicks);
    }

    public void disableActiveLoopedAction() {
        if (this.activeLoopedAction == null) {
            return;
        }
        this.activeLoopedAction.deactivate();
        this.activeLoopedAction = null;
        this.wasActiveLastTick = false;
    }

    public void activateAction(Action action, MenuEntry menuEntry) {
        if (action instanceof LoopedAction) {
            if (this.activeLoopedAction != null) {
                this.activeLoopedAction.deactivate();
            }
            this.setActiveLoopedAction((LoopedAction)action);
        } else {
            action.activate(menuEntry);
        }
    }

    public void activateAction(String actionID, MenuEntry menuEntry) {
        Action action = this.menuActions.get(actionID);
        this.activateAction(action, menuEntry);
    }

    public void activateAction(Action action) {
        this.activateAction(action, null);
    }

    public void activatePriorityAction(String actionID, MenuEntry menuEntry) {
        this.priorityMenuActions.get(actionID).activate(menuEntry);
    }

    public void setDisplayRequirement(Requirement req) {
        this.displayReq = req;
        this.activate();
    }

    private void removeOtherObjects() {
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[this.client.getPlane()];
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.objectToRemove.getWp());
        if (lp == null) {
            return;
        }
        Tile tile = tiles[lp.getSceneX()][lp.getSceneY()];
        if (tile == null) {
            return;
        }
        for (GameObject gameObject : tile.getGameObjects()) {
            if (gameObject == null || gameObject.getId() != this.objectToRemove.getObjectID()) continue;
            scene.removeGameObject(gameObject);
        }
    }

    public void addDialogTree(Requirement req, RuneliteDialogStep dialogTree) {
        this.dialogTrees.put(req, dialogTree);
    }

    public void addTalkAction(RuneliteObjectManager runeliteObjectManager) {
        this.priorityMenuActions.put("Talk-to", new Action(runeliteObjectManager.getTalkAction(this)));
    }

    public void addExamineAction(RuneliteObjectManager runeliteObjectManager) {
        this.menuActions.put("Examine", new Action(runeliteObjectManager.getExamineAction(this)));
    }

    public void addOverheadText(String overheadText, int tickToRemoveOverheadText, ChatMessageManager chatMessageManager) {
        this.overheadText = overheadText;
        this.tickToRemoveOverheadText = tickToRemoveOverheadText;
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(overheadText).build();
        chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.PUBLICCHAT).name(this.name).runeLiteFormattedMessage(chatMessage).timestamp((int)(System.currentTimeMillis() / 1000L)).build());
    }

    public void clearOverheadText() {
        this.overheadText = null;
        this.tickToRemoveOverheadText = 0;
    }

    public void checkPendingAction() {
        if (this.pendingAction != null && this.pendingAction.get().booleanValue()) {
            this.pendingAction = null;
        }
    }

    public void addAction(String name, Consumer<MenuEntry> action) {
        this.menuActions.put(name, new Action(action));
    }

    public void addLoopedAction(String name, Consumer<MenuEntry> action, AtomicInteger ticksBetweenActions) {
        this.menuActions.put(name, new LoopedAction(action, ticksBetweenActions));
    }

    public RuneliteObjectDialogStep createDialogStepForNpc(String text, FaceAnimationIDs faceAnimation) {
        return this.createDialogStepForNpc(text, faceAnimation.getAnimationID());
    }

    public RuneliteObjectDialogStep createDialogStepForNpc(String text, int faceAnimation) {
        if (this.face == -1) {
            throw new IllegalStateException("Face value must be positive");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name must be assigned");
        }
        return new RuneliteObjectDialogStep(this.name, text, this.face, faceAnimation);
    }

    public RuneliteObjectDialogStep createDialogStepForNpc(String text) {
        if (this.face == -1) {
            throw new IllegalStateException("Face value must be positive");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name must be assigned");
        }
        return new RuneliteObjectDialogStep(this.name, text, this.face);
    }

    public RuneliteObjectDialogStep createDialogStepForNpc(String text, RuneliteConfigSetter setter) {
        if (this.face == -1) {
            throw new IllegalStateException("Face value must be positive");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name must be assigned");
        }
        return new RuneliteObjectDialogStep(this.name, text, this.face, setter);
    }

    public RuneliteObjectDialogStep createDialogStepForNpc(String text, int faceAnimation, RuneliteConfigSetter setter) {
        if (this.face == -1) {
            throw new IllegalStateException("Face value must be positive");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name must be assigned");
        }
        return new RuneliteObjectDialogStep(this.name, text, this.face, faceAnimation, setter);
    }

    public void setupChatBox(ChatboxPanelManager chatboxPanelManager) {
        for (Map.Entry<Requirement, RuneliteDialogStep> dialogTree : this.dialogTrees.entrySet()) {
            Requirement requirement = dialogTree.getKey();
            RuneliteDialogStep runeliteDialogStep = dialogTree.getValue();
            if (requirement != null && !requirement.check(this.client)) continue;
            if (runeliteDialogStep.isPlayer()) {
                this.currentChatBox = new PlayerChatBox(this.client, chatboxPanelManager).dialog(runeliteDialogStep).build();
                continue;
            }
            this.currentChatBox = new NpcChatBox(this.client, chatboxPanelManager).dialog(runeliteDialogStep).build();
        }
        if (this.currentChatBox == null) {
            throw new IllegalStateException("No default dialog specified for " + this.getName());
        }
    }

    public void progressDialog() {
        if (this.currentChatBox != null) {
            this.currentChatBox.progressDialog();
        }
    }

    public int calculateRotationFromAtoB(double aX, double aY, double bX, double bY) {
        double xDiff = bX - aX;
        double yDiff = bY - aY;
        double angle = 0.0;
        double aToBAngle = Math.abs(Math.atan(yDiff / xDiff));
        if (xDiff > 0.0 && yDiff <= 0.0) {
            angle = aToBAngle + 4.71238898038469;
        } else if (xDiff >= 0.0 && yDiff > 0.0) {
            angle = Math.atan(xDiff / yDiff) + Math.PI;
        } else if (xDiff < 0.0 && yDiff >= 0.0) {
            angle = aToBAngle + 1.5707963267948966;
        } else if (xDiff <= 0.0 && yDiff < 0.0) {
            angle = Math.atan(xDiff / yDiff);
        }
        int nextOrientation = (int)(angle * 1024.0 / Math.PI - 1024.0);
        if (nextOrientation < 0) {
            nextOrientation += 2048;
        }
        return nextOrientation;
    }

    public void setOrientationGoalAsPlayer(Client client) {
        double playerX = client.getLocalPlayer().getLocalLocation().getX();
        double playerY = client.getLocalPlayer().getLocalLocation().getY();
        double currentNPCX = this.runeliteObject.getLocation().getX();
        double currentNPCY = this.runeliteObject.getLocation().getY();
        int newOrientation = this.calculateRotationFromAtoB(playerX, playerY, currentNPCX, currentNPCY);
        this.setOrientationGoal(newOrientation);
    }

    public boolean partiallyRotateToGoal() {
        boolean isFacingPlayer;
        int MAX_ROTATION_PER_CALL = 32;
        int MAX_ROTATION = 2048;
        int newOrientation = this.getOrientationGoal();
        int existingOrientation = this.runeliteObject.getOrientation();
        boolean isClockwise = Math.floorMod(existingOrientation - newOrientation, 2048) > Math.floorMod(newOrientation - existingOrientation, 2048);
        int additionalRotation = isClockwise ? Math.min(Math.abs(existingOrientation - newOrientation), 32) : -1 * Math.min(Math.abs(newOrientation - existingOrientation), 32);
        int actualNewOrientation = Math.floorMod(existingOrientation + additionalRotation, 2048);
        this.runeliteObject.setOrientation(actualNewOrientation);
        boolean bl = isFacingPlayer = actualNewOrientation == newOrientation;
        if (!isFacingPlayer) {
            // empty if block
        }
        return isFacingPlayer;
    }

    public RuneLiteObject getRuneliteObject() {
        return this.runeliteObject;
    }

    public LinkedHashMap<Requirement, RuneliteDialogStep> getDialogTrees() {
        return this.dialogTrees;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public void setFace(int face) {
        this.face = face;
    }

    public int getFace() {
        return this.face;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExamine() {
        return this.examine;
    }

    public void setExamine(String examine) {
        this.examine = examine;
    }

    public Requirement getDisplayReq() {
        return this.displayReq;
    }

    public String getOverheadText() {
        return this.overheadText;
    }

    public int getTickToRemoveOverheadText() {
        return this.tickToRemoveOverheadText;
    }

    public ReplacedObject getObjectToRemove() {
        return this.objectToRemove;
    }

    public Consumer<MenuEntry> getReplaceWalkAction() {
        return this.replaceWalkAction;
    }

    public void setReplaceWalkAction(Consumer<MenuEntry> replaceWalkAction) {
        this.replaceWalkAction = replaceWalkAction;
    }

    public String getReplaceWalkActionText() {
        return this.replaceWalkActionText;
    }

    public void setReplaceWalkActionText(String replaceWalkActionText) {
        this.replaceWalkActionText = replaceWalkActionText;
    }

    public Map<String, Action> getMenuActions() {
        return this.menuActions;
    }

    public Map<String, Action> getPriorityMenuActions() {
        return this.priorityMenuActions;
    }

    public void setActiveLoopedAction(LoopedAction activeLoopedAction) {
        this.activeLoopedAction = activeLoopedAction;
    }

    public String getNameColor() {
        return this.nameColor;
    }

    public boolean isHiddenNoOptions() {
        return this.isHiddenNoOptions;
    }

    public void setHiddenNoOptions(boolean isHiddenNoOptions) {
        this.isHiddenNoOptions = isHiddenNoOptions;
    }

    public int getOrientationGoal() {
        return this.orientationGoal;
    }

    public void setOrientationGoal(int orientationGoal) {
        this.orientationGoal = orientationGoal;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setNeedToBeCloseToTalk(boolean needToBeCloseToTalk) {
        this.needToBeCloseToTalk = needToBeCloseToTalk;
    }

    public boolean isNeedToBeCloseToTalk() {
        return this.needToBeCloseToTalk;
    }

    public int getDisableAfterTick() {
        return this.disableAfterTick;
    }

    public void setDisableAfterTick(int disableAfterTick) {
        this.disableAfterTick = disableAfterTick;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setPendingAction(Supplier<Boolean> pendingAction) {
        this.pendingAction = pendingAction;
    }

    public Supplier<Boolean> getPendingAction() {
        return this.pendingAction;
    }
}

