/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.extendedruneliteobjects;

import com.questhelper.runeliteobjects.dialog.RuneliteDialogStep;
import com.questhelper.runeliteobjects.extendedruneliteobjects.NpcChatBox;
import com.questhelper.runeliteobjects.extendedruneliteobjects.PlayerChatBox;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;

public class ChatBox
extends ChatboxInput
implements KeyListener {
    protected final Client client;
    protected final ChatboxPanelManager chatboxPanelManager;
    protected RuneliteDialogStep dialog;
    private final List<Entry> options = new ArrayList<Entry>();
    private Runnable onClose;
    RuneliteDialogStep nextDialog;
    ChatBox nextChatBox;
    boolean chatProgressed = false;
    Widget continueW;

    @Inject
    protected ChatBox(Client client, ChatboxPanelManager chatboxPanelManager) {
        this.client = client;
        this.chatboxPanelManager = chatboxPanelManager;
    }

    public ChatBox dialog(RuneliteDialogStep dialog) {
        this.dialog = dialog;
        return this;
    }

    public ChatBox option(String text, Runnable callback) {
        this.options.add(new Entry(text, callback));
        return this;
    }

    public ChatBox onClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }

    public ChatBox build() {
        if (this.dialog == null) {
            throw new IllegalStateException("Dialog must be set");
        }
        this.chatboxPanelManager.openInput((ChatboxInput)this);
        return this;
    }

    protected void open() {
        Widget container = this.chatboxPanelManager.getContainerWidget();
        Widget npcFaceWidget = container.createChild(0, 3);
        npcFaceWidget.setType(6);
        npcFaceWidget.setModelId(this.dialog.getFaceID());
        npcFaceWidget.setModelType(2);
        npcFaceWidget.setAnimationId(this.dialog.getAnimation());
        npcFaceWidget.setRotationX(40);
        npcFaceWidget.setRotationZ(1882);
        npcFaceWidget.setModelZoom(796);
        npcFaceWidget.setOriginalX(46);
        npcFaceWidget.setOriginalY(53);
        npcFaceWidget.setOriginalWidth(32);
        npcFaceWidget.setOriginalHeight(32);
        npcFaceWidget.setXPositionMode(0);
        npcFaceWidget.setYPositionMode(0);
        npcFaceWidget.revalidate();
        this.setupDialog(container, 96);
    }

    public void setupDialog(Widget container, int x) {
        int WRAPPER_HEIGHT_ADJUSTMENT = 17;
        int WRAPPER_WIDTH_ADJUSTMENT = 12;
        Widget nameWidget = container.createChild(-1, 4);
        nameWidget.setText(this.dialog.getName());
        nameWidget.setTextColor(0x800000);
        nameWidget.setFontId(497);
        nameWidget.setXPositionMode(0);
        nameWidget.setOriginalX(WRAPPER_WIDTH_ADJUSTMENT + x);
        nameWidget.setYPositionMode(0);
        nameWidget.setOriginalY(WRAPPER_HEIGHT_ADJUSTMENT);
        nameWidget.setOriginalWidth(380);
        nameWidget.setOriginalHeight(17);
        nameWidget.setXTextAlignment(1);
        nameWidget.setYTextAlignment(1);
        nameWidget.setWidthMode(0);
        nameWidget.revalidate();
        Widget continueWidget = container.createChild(-1, 4);
        continueWidget.setText("Click here to continue");
        continueWidget.setTextColor(255);
        continueWidget.setFontId(497);
        continueWidget.setXPositionMode(0);
        continueWidget.setOriginalX(WRAPPER_WIDTH_ADJUSTMENT + x);
        continueWidget.setYPositionMode(0);
        continueWidget.setOriginalY(WRAPPER_HEIGHT_ADJUSTMENT + 80);
        continueWidget.setOriginalWidth(380);
        continueWidget.setOriginalHeight(17);
        continueWidget.setXTextAlignment(1);
        continueWidget.setYTextAlignment(1);
        continueWidget.setWidthMode(0);
        continueWidget.setAction(0, "Continue");
        continueWidget.setOnOpListener(new Object[]{ev -> {
            continueWidget.setText("Please wait...");
            this.continueChat();
        }});
        continueWidget.setOnMouseOverListener(new Object[]{ev -> continueWidget.setTextColor(0xFFFFFF)});
        continueWidget.setOnMouseLeaveListener(new Object[]{ev -> continueWidget.setTextColor(255)});
        continueWidget.setHasListener(true);
        continueWidget.revalidate();
        this.continueW = continueWidget;
        Widget dialogWidget = container.createChild(-1, 4);
        dialogWidget.setText(this.dialog.getText());
        dialogWidget.setTextColor(0);
        dialogWidget.setFontId(497);
        dialogWidget.setXPositionMode(0);
        dialogWidget.setOriginalX(WRAPPER_WIDTH_ADJUSTMENT + x);
        dialogWidget.setYPositionMode(0);
        dialogWidget.setOriginalY(WRAPPER_HEIGHT_ADJUSTMENT + 16);
        dialogWidget.setOriginalWidth(380);
        dialogWidget.setOriginalHeight(67);
        dialogWidget.setXTextAlignment(1);
        dialogWidget.setYTextAlignment(1);
        dialogWidget.setWidthMode(0);
        dialogWidget.revalidate();
    }

    public void progressDialog() {
        if (this.nextDialog == null) {
            return;
        }
        if (this.nextChatBox != null) {
            this.nextChatBox.progressDialog();
            return;
        }
        if (this.nextDialog.isPlayer()) {
            this.nextChatBox = new PlayerChatBox(this.client, this.chatboxPanelManager).dialog(this.nextDialog).build();
            return;
        }
        this.nextChatBox = new NpcChatBox(this.client, this.chatboxPanelManager).dialog(this.nextDialog).build();
    }

    protected void continueChat() {
        this.dialog.progressState();
        if (this.nextDialog != null) {
            return;
        }
        this.nextDialog = this.dialog.getContinueDialog();
        if (this.nextDialog == null) {
            this.chatboxPanelManager.close();
        }
    }

    private void callback(Entry entry) {
        Widget container = this.chatboxPanelManager.getContainerWidget();
        container.setOnKeyListener((Object[])null);
        this.chatboxPanelManager.close();
        entry.callback.run();
    }

    protected void close() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void keyTyped(KeyEvent e) {
        int n;
        if (!this.chatboxPanelManager.shouldTakeInput()) {
            return;
        }
        char c = e.getKeyChar();
        if (c == '\u001b') {
            this.chatboxPanelManager.close();
            e.consume();
            return;
        }
        if (c == ' ') {
            if (this.continueW != null) {
                this.continueW.setText("Please wait...");
            }
            this.continueChat();
        }
        if ((n = c - 49) >= 0 && n < this.options.size()) {
            this.callback(this.options.get(n));
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this.chatboxPanelManager.shouldTakeInput()) {
            return;
        }
        if (e.getKeyCode() == 27) {
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public RuneliteDialogStep getDialog() {
        return this.dialog;
    }

    public List<Entry> getOptions() {
        return this.options;
    }

    public Runnable getOnClose() {
        return this.onClose;
    }

    private static final class Entry {
        private String text;
        private Runnable callback;

        public String getText() {
            return this.text;
        }

        public Runnable getCallback() {
            return this.callback;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setCallback(Runnable callback) {
            this.callback = callback;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Runnable this$callback = this.getCallback();
            Runnable other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Runnable $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        public String toString() {
            return "ChatBox.Entry(text=" + this.getText() + ", callback=" + this.getCallback() + ")";
        }

        public Entry(String text, Runnable callback) {
            this.text = text;
            this.callback = callback;
        }
    }
}

