/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects.dialog;

import com.questhelper.runeliteobjects.RuneliteConfigSetter;
import java.util.ArrayList;

public class RuneliteDialogStep {
    protected final String name;
    protected final String text;
    protected final int faceID;
    protected final int animation;
    private RuneliteDialogStep continueDialog;
    private RuneliteConfigSetter stateProgression;
    private final ArrayList<RuneliteDialogStep> dialogChoices = new ArrayList();

    public RuneliteDialogStep(String name, String text, int faceID, int animation) {
        this.name = name;
        this.text = text;
        this.animation = animation;
        this.faceID = faceID;
    }

    public RuneliteDialogStep(String name, String text, int faceID, int animation, RuneliteConfigSetter setter) {
        this.name = name;
        this.text = text;
        this.animation = animation;
        this.faceID = faceID;
        this.setStateProgression(setter);
    }

    public RuneliteDialogStep setStateProgression(RuneliteConfigSetter stateProgression) {
        this.stateProgression = stateProgression;
        return this;
    }

    public void addNewDialogChoice(RuneliteDialogStep step) {
        this.dialogChoices.add(step);
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isStateChanger() {
        return this.stateProgression != null;
    }

    public void progressState() {
        if (this.isStateChanger()) {
            this.stateProgression.setConfigValue();
        }
    }

    public RuneliteDialogStep addContinueDialog(RuneliteDialogStep continueDialog) {
        this.continueDialog = continueDialog;
        return continueDialog;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public int getFaceID() {
        return this.faceID;
    }

    public int getAnimation() {
        return this.animation;
    }

    public RuneliteDialogStep getContinueDialog() {
        return this.continueDialog;
    }

    public RuneliteConfigSetter getStateProgression() {
        return this.stateProgression;
    }

    public ArrayList<RuneliteDialogStep> getDialogChoices() {
        return this.dialogChoices;
    }
}

