/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.runeliteobjects;

import com.questhelper.QuestHelperConfig;
import com.questhelper.questinfo.PlayerQuests;
import com.questhelper.requirements.runelite.PlayerQuestStateRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.runeliteobjects.Cheerer;
import com.questhelper.runeliteobjects.extendedruneliteobjects.ReplacedNpc;
import com.questhelper.runeliteobjects.extendedruneliteobjects.RuneliteObjectManager;
import com.questhelper.runeliteobjects.extendedruneliteobjects.WidgetReplacement;
import com.questhelper.steps.WidgetDetails;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;

public class GlobalFakeObjects {
    private static boolean initialized;

    public static void createNpcs(Client client, RuneliteObjectManager runeliteObjectManager, ConfigManager configManager, QuestHelperConfig questHelperConfig) {
        if (initialized || !questHelperConfig.showRuneliteObjects()) {
            return;
        }
        initialized = true;
        GlobalFakeObjects.createHopleez(runeliteObjectManager, client, configManager);
        Cheerer.createCheerers(runeliteObjectManager, client, configManager);
    }

    public static void disableNpcs(RuneliteObjectManager runeliteObjectManager) {
        if (!initialized) {
            return;
        }
        runeliteObjectManager.removeGroupAndSubgroups("global");
        initialized = false;
    }

    private static void createHopleez(RuneliteObjectManager runeliteObjectManager, Client client, ConfigManager configManager) {
        ReplacedNpc replacedHopleez = runeliteObjectManager.createReplacedNpc(client.getNpcDefinition(7481).getModels(), new WorldPoint(3235, 3215, 0), 5523);
        replacedHopleez.setName("Hopleez");
        replacedHopleez.setFace(7481);
        replacedHopleez.setExamine("He was here first.");
        replacedHopleez.addExamineAction(runeliteObjectManager);
        replacedHopleez.setDisplayRequirement(new PlayerQuestStateRequirement(configManager, PlayerQuests.COOKS_HELPER, 4, Operation.GREATER_EQUAL));
        replacedHopleez.addWidgetReplacement(new WidgetReplacement(new WidgetDetails(15138822), "Hatius Cosaintus", "Hopleez"));
    }

    public static void setInitialized(boolean initialized) {
        GlobalFakeObjects.initialized = initialized;
    }
}

