/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.rewards;

import com.questhelper.rewards.Reward;
import com.questhelper.rewards.RewardType;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.runelite.api.Skill;
import net.runelite.client.util.QuantityFormatter;

public class ExperienceReward
implements Reward {
    private final Skill skill;
    private final int experience;
    private final boolean lamp;

    public ExperienceReward(Skill skill, int experience) {
        this(skill, experience, false);
    }

    public ExperienceReward(Skill skill, int experience, boolean lamp) {
        this.skill = skill;
        this.experience = experience;
        this.lamp = lamp;
    }

    @Override
    @Nonnull
    public RewardType rewardType() {
        return RewardType.EXPERIENCE;
    }

    @Override
    @Nonnull
    public String getDisplayText() {
        if (this.lamp) {
            return QuantityFormatter.formatNumber((long)this.experience) + " " + Character.toUpperCase(this.skill.name().charAt(0)) + this.skill.name().toLowerCase(Locale.ROOT).substring(1) + " Experience Lamp";
        }
        return QuantityFormatter.formatNumber((long)this.experience) + " " + Character.toUpperCase(this.skill.name().charAt(0)) + this.skill.name().toLowerCase(Locale.ROOT).substring(1) + " Experience";
    }
}

