/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.zone;

import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.zone.Zone;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class ZoneRequirement
extends AbstractRequirement {
    private final List<Zone> zones;
    private final boolean checkInZone;
    private String displayText;

    public ZoneRequirement(String displayText, Zone zone) {
        this(displayText, false, zone);
    }

    public ZoneRequirement(String displayText, boolean checkNotInZone, Zone zone) {
        this.displayText = displayText;
        this.checkInZone = !checkNotInZone;
        this.zones = QuestUtil.toArrayList(zone);
    }

    public ZoneRequirement(WorldPoint ... worldPoints) {
        this.zones = Stream.of(worldPoints).map(Zone::new).collect(QuestUtil.collectToArrayList());
        this.checkInZone = true;
    }

    public ZoneRequirement(Zone ... zone) {
        this.zones = QuestUtil.toArrayList(zone);
        this.checkInZone = true;
    }

    public ZoneRequirement(boolean checkInZone, Zone ... zone) {
        this.zones = QuestUtil.toArrayList(zone);
        this.checkInZone = checkInZone;
    }

    public ZoneRequirement(boolean checkInZone, WorldPoint ... worldPoints) {
        this.zones = Stream.of(worldPoints).map(Zone::new).collect(QuestUtil.collectToArrayList());
        this.checkInZone = checkInZone;
    }

    @Override
    public boolean check(Client client) {
        Player player = client.getLocalPlayer();
        if (player != null && this.zones != null) {
            WorldPoint location = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)player.getLocalLocation());
            boolean inZone = this.zones.stream().anyMatch(z -> z.contains(location));
            return inZone == this.checkInZone;
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDisplayText() {
        return this.displayText == null ? "" : this.displayText;
    }
}

