/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.zone;

import net.runelite.api.coords.WorldPoint;

public class Zone {
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private int minPlane = 0;
    private int maxPlane = 2;

    public Zone() {
        this.minX = 1152;
        this.maxX = 3903;
        this.minY = 2496;
        this.maxY = 4159;
        this.maxPlane = 0;
    }

    public Zone(WorldPoint p1, WorldPoint p2) {
        this.minX = Math.min(p1.getX(), p2.getX());
        this.maxX = Math.max(p1.getX(), p2.getX());
        this.minY = Math.min(p1.getY(), p2.getY());
        this.maxY = Math.max(p1.getY(), p2.getY());
        this.minPlane = Math.min(p1.getPlane(), p2.getPlane());
        this.maxPlane = Math.max(p1.getPlane(), p2.getPlane());
    }

    public Zone(WorldPoint p) {
        this.minX = p.getX();
        this.maxX = p.getX();
        this.minY = p.getY();
        this.maxY = p.getY();
        this.minPlane = p.getPlane();
        this.maxPlane = p.getPlane();
    }

    public Zone(int regionID) {
        this.minX = (regionID >> 8 & 0xFF) << 6;
        this.maxX = this.minX + 64;
        this.minY = (regionID & 0xFF) << 6;
        this.maxY = this.minY + 64;
    }

    public Zone(int regionID, int plane) {
        this(regionID);
        this.minPlane = plane;
        this.maxPlane = plane;
    }

    public boolean contains(WorldPoint worldPoint) {
        return this.minX <= worldPoint.getX() && worldPoint.getX() <= this.maxX && this.minY <= worldPoint.getY() && worldPoint.getY() <= this.maxY && this.minPlane <= worldPoint.getPlane() && worldPoint.getPlane() <= this.maxPlane;
    }

    public WorldPoint getMinWorldPoint() {
        return new WorldPoint(this.minX, this.minY, this.minPlane);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }
}

