/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.widget;

import com.questhelper.requirements.SimpleRequirement;
import com.questhelper.util.Utils;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetTextRequirement
extends SimpleRequirement {
    protected boolean hasPassed;
    private final int groupId;
    private final int childId;
    private final List<String> text;
    private int childChildId = -1;
    private boolean checkChildren;
    private int min = -1;
    private int max = -1;

    public WidgetTextRequirement(int componentId, String ... text) {
        Pair<Integer, Integer> pair = Utils.unpackWidget(componentId);
        this.groupId = (Integer)pair.getLeft();
        this.childId = (Integer)pair.getRight();
        this.text = Arrays.asList(text);
    }

    public WidgetTextRequirement(int componentId, boolean checkChildren, String ... text) {
        Pair<Integer, Integer> pair = Utils.unpackWidget(componentId);
        this.groupId = (Integer)pair.getLeft();
        this.childId = (Integer)pair.getRight();
        this.checkChildren = checkChildren;
        this.text = Arrays.asList(text);
    }

    public WidgetTextRequirement(int groupId, int childId, boolean checkChildren, String ... text) {
        this.groupId = groupId;
        this.childId = childId;
        this.checkChildren = checkChildren;
        this.text = Arrays.asList(text);
    }

    public WidgetTextRequirement(int groupId, int childId, String ... text) {
        this.groupId = groupId;
        this.childId = childId;
        this.text = Arrays.asList(text);
    }

    public WidgetTextRequirement(int groupId, int childId, int childChildId, String ... text) {
        this.groupId = groupId;
        this.childId = childId;
        this.childChildId = childChildId;
        this.text = Arrays.asList(text);
    }

    public void addRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean check(Client client) {
        return this.checkWidget(client);
    }

    public boolean checkWidget(Client client) {
        Widget widget = client.getWidget(this.groupId, this.childId);
        if (widget != null) {
            if (this.childChildId != -1) {
                widget = widget.getChild(this.childChildId);
            }
            if (widget != null) {
                for (String textOption : this.text) {
                    if (this.checkChildren && this.getChildren(widget, textOption) && !widget.isHidden()) {
                        return true;
                    }
                    if (!widget.getText().contains(textOption) || widget.isHidden()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean getChildren(Widget parentWidget, String textOption) {
        int currentMax;
        int currentMin;
        Widget[] children = parentWidget.getStaticChildren();
        if (children.length == 0) {
            return false;
        }
        if (this.max == -1 || this.min == -1) {
            currentMin = 0;
            currentMax = children.length;
        } else {
            currentMax = Math.min(children.length, this.max);
            currentMin = Math.max(0, this.min);
        }
        for (int i = currentMin; i < currentMax; ++i) {
            Widget currentWidget = parentWidget.getStaticChildren()[i];
            if (!(currentWidget.getNestedChildren() != null ? currentWidget.getText().contains(textOption) : this.getChildren(currentWidget, textOption))) continue;
            return true;
        }
        return false;
    }

    public void checkWidgetText(Client client) {
        this.hasPassed = this.hasPassed || this.checkWidget(client);
    }

    public void setHasPassed(boolean hasPassed) {
        this.hasPassed = hasPassed;
    }

    public boolean isHasPassed() {
        return this.hasPassed;
    }

    public int getGroupId() {
        return this.groupId;
    }
}

