/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.widget;

import com.questhelper.requirements.SimpleRequirement;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public class WidgetPresenceRequirement
extends SimpleRequirement {
    protected boolean hasPassed;
    protected boolean onlyNeedToPassOnce;
    protected final int groupId;
    protected final int childId;
    protected int childChildId = -1;

    public WidgetPresenceRequirement(int groupId, int childId, int childChildId) {
        this.groupId = groupId;
        this.childId = childId;
        this.childChildId = childChildId;
    }

    public WidgetPresenceRequirement(int groupId, int childId) {
        this.groupId = groupId;
        this.childId = childId;
    }

    @Override
    public boolean check(Client client) {
        if (this.onlyNeedToPassOnce && this.hasPassed) {
            return true;
        }
        return this.checkWidget(client);
    }

    @Nullable
    protected Widget getWidget(Client client) {
        Widget widget = client.getWidget(this.groupId, this.childId);
        if (widget == null) {
            return null;
        }
        if (this.childChildId != -1) {
            return widget.getChild(this.childChildId);
        }
        return widget;
    }

    public boolean checkWidget(Client client) {
        return this.getWidget(client) != null;
    }

    public void setHasPassed(boolean hasPassed) {
        this.hasPassed = hasPassed;
    }

    public boolean isHasPassed() {
        return this.hasPassed;
    }

    public int getGroupId() {
        return this.groupId;
    }
}

