/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.requirements.var;

import com.questhelper.requirements.AbstractRequirement;
import com.questhelper.requirements.util.Operation;
import java.math.BigInteger;
import java.util.Locale;
import net.runelite.api.Client;

public class VarplayerRequirement
extends AbstractRequirement {
    private final int varplayerId;
    private final int value;
    private final Operation operation;
    private final String displayText;
    private final int bitPosition;
    private final boolean bitIsSet;

    public VarplayerRequirement(int varplayerId, int value) {
        this.varplayerId = varplayerId;
        this.value = value;
        this.operation = Operation.EQUAL;
        this.displayText = null;
        this.bitPosition = -1;
        this.bitIsSet = false;
        this.shouldCountForFilter = true;
    }

    public VarplayerRequirement(int varplayerId, int value, String displayText) {
        this.varplayerId = varplayerId;
        this.value = value;
        this.operation = Operation.EQUAL;
        this.displayText = displayText;
        this.bitPosition = -1;
        this.bitIsSet = false;
        this.shouldCountForFilter = true;
    }

    public VarplayerRequirement(int varplayerId, int value, Operation operation) {
        this.varplayerId = varplayerId;
        this.value = value;
        this.operation = operation;
        this.displayText = null;
        this.bitPosition = -1;
        this.bitIsSet = false;
        this.shouldCountForFilter = true;
    }

    public VarplayerRequirement(int varplayerId, int value, Operation operation, String displayText) {
        this.varplayerId = varplayerId;
        this.value = value;
        this.operation = operation;
        this.displayText = displayText;
        this.bitPosition = -1;
        this.bitIsSet = false;
        this.shouldCountForFilter = true;
    }

    public VarplayerRequirement(int varplayerId, boolean bitIsSet, int bitPosition) {
        this.varplayerId = varplayerId;
        this.value = -1;
        this.operation = Operation.EQUAL;
        this.displayText = null;
        this.bitPosition = bitPosition;
        this.bitIsSet = bitIsSet;
        this.shouldCountForFilter = true;
    }

    public VarplayerRequirement(int varplayerId, boolean bitIsSet, int bitPosition, String displayText) {
        this.varplayerId = varplayerId;
        this.value = -1;
        this.operation = Operation.EQUAL;
        this.displayText = displayText;
        this.bitPosition = bitPosition;
        this.bitIsSet = bitIsSet;
        this.shouldCountForFilter = true;
    }

    @Override
    public boolean check(Client client) {
        if (this.bitPosition >= 0) {
            return this.bitIsSet == BigInteger.valueOf(client.getVarpValue(this.varplayerId)).testBit(this.bitPosition);
        }
        return this.operation.check(client.getVarpValue(this.varplayerId), this.value);
    }

    @Override
    public String getDisplayText() {
        if (this.displayText != null) {
            return this.displayText;
        }
        if (this.bitPosition >= 0) {
            return this.varplayerId + " must have the " + this.bitPosition + " bit set.";
        }
        return this.varplayerId + " must be + " + this.operation.name().toLowerCase(Locale.ROOT) + " " + this.value;
    }
}

